/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.ComponentDataSenseResult;

public class ToolingComponentDataSenseResult
implements ComponentDataSenseResult {
    private List<String> messages;
    private Map<String, MetadataType> metadataTypes;
    private List<ComponentDataSenseNotification> notifications;
    private boolean allowRetyping;

    public ToolingComponentDataSenseResult(Map<String, MetadataType> metadataTypes, List<String> messages, List<ComponentDataSenseNotification> notifications, boolean allowRetyping) {
        this.metadataTypes = metadataTypes;
        this.messages = messages;
        this.notifications = notifications;
        this.allowRetyping = allowRetyping;
    }

    @Override
    public boolean isAllowRetyping() {
        return this.allowRetyping;
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public List<ComponentDataSenseNotification> getNotifcations() {
        return this.notifications;
    }

    @Override
    public Map<String, MetadataType> getMetadataTypes() {
        return this.metadataTypes;
    }

    public static final class ComponentDataSenseResultBuilder {
        public static final ComponentDataSenseResult DEFAULT = new ComponentDataSenseResultBuilder().build();
        private List<String> messages = Collections.emptyList();
        private Map<String, MetadataType> metadataTypes = Collections.emptyMap();
        private List<ComponentDataSenseNotification> notifications = Collections.emptyList();
        private boolean allowRetyping = false;

        public ComponentDataSenseResult build() {
            return new ToolingComponentDataSenseResult(this.metadataTypes, this.messages, this.notifications, this.allowRetyping);
        }

        public ComponentDataSenseResultBuilder withMetadataTypes(Map<String, MetadataType> metadataTypes) {
            this.metadataTypes = metadataTypes;
            return this;
        }

        public ComponentDataSenseResultBuilder withMessages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public ComponentDataSenseResultBuilder withNotifications(List<ComponentDataSenseNotification> notifications) {
            this.notifications = notifications;
            return this;
        }

        public ComponentDataSenseResultBuilder withAllowRetyping(boolean allowRetyping) {
            this.allowRetyping = allowRetyping;
            return this;
        }
    }
}

