/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.agent.impl.DefaultAgentToolingClient;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.metadata.ToolingMetadataCacheStorageFactory;
import org.mule.tooling.client.mock.impl.DefaultMockToolingClient;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.tooling.ToolingClientBootstrap;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.runtime.controller.IMuleInstance;

public class ToolingClientFactory {
    private final String MOCK_TOOLING_CLIENT = "mockToolingClient";

    public static ToolingClientFactory getInstance() {
        return LazyHolder.instance;
    }

    public static ToolingClient buildToolingClient(IMuleInstance instance, IMuleProject muleProject) throws Exception {
        return ToolingClientFactory.getInstance().doBuildToolingClient(instance, muleProject);
    }

    public synchronized ToolingClient doBuildToolingClient(IMuleInstance instance, IMuleProject muleProject) throws Exception {
        boolean useMockClient = Boolean.getBoolean("mockToolingClient");
        if (useMockClient) {
            return new DefaultMockToolingClient();
        }
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        int defaultConnectionTimeout = preferenceStore.getInt("toolingClient.defaultConnectionTimeout");
        int defaultReadTimeout = preferenceStore.getInt("toolingClient.defaultReadTimeout");
        ToolingRuntimeClientBootstrap bootstrap = ToolingClientBootstrap.buildToolingBootstrap((IMuleProject)muleProject);
        if (bootstrap != null) {
            String toolingApiURL = instance.toolingURL();
            String authorizationToken = instance.getAgentToken();
            String muleVersion = muleProject.getServerDefinition().getVersion();
            try {
                String toolingInstanceMuleVersion = ToolingManager.getLatestServerDefinition().getVersionWithSuffix();
                AgentConfiguration.Builder configurationBuilder = AgentConfiguration.builder().withToolingApiUrl(new URL(toolingApiURL)).withAuthorizationToken(authorizationToken).withMuleVersion(toolingInstanceMuleVersion).withDefaultConnectionTimeout((long)defaultConnectionTimeout).withDefaultReadTimeout((long)defaultReadTimeout);
                ToolingRuntimeClient.Builder toolingClientBuilder = bootstrap.getToolingRuntimeClientBuilderFactory().create();
                toolingClientBuilder.withTargetRuntimeVersion().ifEnabled(action -> action.perform((Object)muleVersion));
                if (toolingClientBuilder.withMetadataCacheStorageFactory().isEnabled()) {
                    toolingClientBuilder.withMetadataCacheStorageFactory().ifEnabled(action -> action.perform((Object)new ToolingMetadataCacheStorageFactory()));
                } else {
                    MuleCorePlugin.logWarning((String)String.format("Cannot configure metadata cache storage for tooling version [%s] and mule version [%s]. Performance may be affected by this. If you are not using the latest components, please consider updating your Studio installation.", bootstrap.getToolingVersion(), muleVersion));
                }
                ToolingRuntimeClient toolingRuntimeClient = toolingClientBuilder.withMavenConfiguration(this.getToolingMavenConfiguration()).withRemoteAgentConfiguration(configurationBuilder.build()).build();
                return new DefaultAgentToolingClient(toolingRuntimeClient);
            }
            catch (MalformedURLException e) {
                MuleCorePlugin.logError((String)("Could not parse tooling URL '" + toolingApiURL + "'"), (Throwable)e);
                return null;
            }
        }
        MuleCorePlugin.logWarning((String)"Unable to create ToolingClient.");
        return null;
    }

    private MavenConfiguration getToolingMavenConfiguration() {
        return MavenCore.newUserMavenConfiguration();
    }

    private static class LazyHolder {
        private static final ToolingClientFactory instance = (ToolingClientFactory)EclipseContextHelper.createFromStudioContext(ToolingClientFactory.class);

        private LazyHolder() {
        }
    }
}

