/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.ToolingRequestContext;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingProjectFile;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;

public abstract class ToolingApplicationServiceExecutorTemplate<T> {
    private static final String NO_STACK_TRACE_MESSAGE = "(No stack trace available)";
    private static final String INVALID_CONFIG_MESSAGE = "The current configuration is not part of the project's deployable set of configurations";
    protected final IMuleProject project;
    protected final MuleConfiguration muleConfiguration;
    protected final ToolingWorkspace toolingWorkspace;
    protected final IMuleInstance muleInstance;
    protected final String generalErrorMessage;
    protected final IMessageFlowNode messageFlowNode;
    protected final Supplier<IMessageFlowNode> newMessageFlowNodeSupplier;
    protected final Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider;

    protected ToolingApplicationServiceExecutorTemplate(ToolingApplicationServiceExecutorTemplateBuilder<?, ?> builder) {
        Objects.requireNonNull(builder.toolingWorkspace);
        Objects.requireNonNull(builder.muleInstance);
        Objects.requireNonNull(builder.project);
        Objects.requireNonNull(builder.muleConfiguration);
        Objects.requireNonNull(builder.messageFlowNode);
        Objects.requireNonNull(builder.newMessageFlowNodeSupplier);
        Objects.requireNonNull(builder.updatedPropertiesProvider);
        assert (StringUtils.isNotBlank((CharSequence)builder.generalErrorMessage));
        this.toolingWorkspace = builder.toolingWorkspace;
        this.muleInstance = builder.muleInstance;
        this.project = builder.project;
        this.muleConfiguration = builder.muleConfiguration;
        this.generalErrorMessage = builder.generalErrorMessage;
        this.messageFlowNode = builder.messageFlowNode;
        this.newMessageFlowNodeSupplier = builder.newMessageFlowNodeSupplier;
        this.updatedPropertiesProvider = builder.updatedPropertiesProvider;
    }

    public ServiceResponse<T> runServiceRequest() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ToolingProject toolingProject = this.toolingWorkspace.install(this.project);){
                Optional maybeToolingProjectFile = toolingProject.getProjectFile(this.muleConfiguration);
                if (maybeToolingProjectFile.isPresent()) {
                    ToolingProjectFile projectFile = (ToolingProjectFile)maybeToolingProjectFile.get();
                    return this.runOnToolingApplication(toolingProject, projectFile);
                }
                return ServiceResponseFactory.failure(INVALID_CONFIG_MESSAGE, NO_STACK_TRACE_MESSAGE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)this.generalErrorMessage, (Throwable)e);
            return ServiceResponseFactory.failure(e);
        }
    }

    private ServiceResponse<T> runOnToolingApplication(ToolingProject toolingProject, ToolingProjectFile projectFile) throws Exception, IOException, MalformedURLException {
        ToolingClient toolingClient = ToolingClientFactory.buildToolingClient(this.muleInstance, this.project);
        IMessageFlowNode messageFlowNode = this.getUpdatedMessageFlowNode(projectFile);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ToolingApplication toolingApplication = toolingClient.newToolingApplication(toolingProject);){
            ToolingRequestContext context = new ToolingRequestContext(messageFlowNode, projectFile, toolingApplication);
            return this.doRunService(context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IMessageFlowNode getUpdatedMessageFlowNode(ToolingProjectFile projectFile) throws Exception {
        return projectFile.saveElement(this.messageFlowNode, this.newMessageFlowNodeSupplier, this.updatedPropertiesProvider);
    }

    protected abstract ServiceResponse<T> doRunService(ToolingRequestContext var1);

    public static abstract class ToolingApplicationServiceExecutorTemplateBuilder<T, R extends ToolingApplicationServiceExecutorTemplateBuilder<T, R>> {
        protected IMuleProject project;
        protected MuleConfiguration muleConfiguration;
        protected ToolingWorkspace toolingWorkspace;
        protected IMuleInstance muleInstance;
        protected String generalErrorMessage;
        protected IMessageFlowNode messageFlowNode;
        protected Supplier<IMessageFlowNode> newMessageFlowNodeSupplier;
        protected Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider;

        public R project(IMuleProject project) {
            this.project = project;
            return this.self();
        }

        public R muleConfiguration(MuleConfiguration muleConfiguration) {
            this.muleConfiguration = muleConfiguration;
            return this.self();
        }

        public R toolingWorkspace(ToolingWorkspace toolingWorkspace) {
            this.toolingWorkspace = toolingWorkspace;
            return this.self();
        }

        public R muleInstance(IMuleInstance muleInstance) {
            this.muleInstance = muleInstance;
            return this.self();
        }

        public R generalErrorMessage(String generalErrorMessage) {
            this.generalErrorMessage = generalErrorMessage;
            return this.self();
        }

        public R messageFlowNode(IMessageFlowNode messageFlowNode) {
            this.messageFlowNode = messageFlowNode;
            return this.self();
        }

        public R newMessageFlowNodeSupplier(Supplier<IMessageFlowNode> newMessageFlowNodeSupplier) {
            this.newMessageFlowNodeSupplier = newMessageFlowNodeSupplier;
            return this.self();
        }

        public R updatedPropertiesProvider(Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider) {
            this.updatedPropertiesProvider = updatedPropertiesProvider;
            return this.self();
        }

        public abstract ToolingApplicationServiceExecutorTemplate<T> build();

        protected abstract R self();
    }
}

