/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Objects;
import org.mule.tooling.client.ToolingApplicationServiceExecutorTemplate;
import org.mule.tooling.client.ToolingRequestContext;
import org.mule.tooling.client.api.ConnectionToolingService;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;

public class TestConnectionExecutor
extends ToolingApplicationServiceExecutorTemplate<Boolean> {
    private final int timeOutInMilliseconds;

    protected TestConnectionExecutor(TestConnectionExecutorBuilder builder) {
        super(builder);
        this.timeOutInMilliseconds = builder.timeOutInMilliseconds;
    }

    @Override
    protected ServiceResponse<Boolean> doRunService(ToolingRequestContext context) {
        ConnectionToolingService connectionToolingService = context.getToolingApplication().getConnectionToolingService();
        String componentId = CoreUtils.getNameProperty((IMessageFlowNode)context.getMessageFlowNode());
        Objects.requireNonNull(componentId);
        return connectionToolingService.testConnection(componentId, this.timeOutInMilliseconds);
    }

    public static class TestConnectionExecutorBuilder
    extends ToolingApplicationServiceExecutorTemplate.ToolingApplicationServiceExecutorTemplateBuilder<Boolean, TestConnectionExecutorBuilder> {
        int timeOutInMilliseconds;

        public TestConnectionExecutor build() {
            return new TestConnectionExecutor(this);
        }

        public TestConnectionExecutorBuilder timeOutInMilliseconds(int timeOutInMilliseconds) {
            this.timeOutInMilliseconds = timeOutInMilliseconds;
            return this.self();
        }

        @Override
        protected TestConnectionExecutorBuilder self() {
            return this;
        }
    }
}

