/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.ToolingApplicationServiceExecutorTemplate;
import org.mule.tooling.client.ToolingRequestContext;
import org.mule.tooling.client.api.MetadataToolingService;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataFailure;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.core.MuleCorePlugin;

public class MetadataKeysServiceExecutor
extends ToolingApplicationServiceExecutorTemplate<MetadataKeysContainer> {
    private final String componentLocation;

    private MetadataKeysServiceExecutor(MetadataKeysExecutorBuilder builder) {
        super(builder);
        assert (StringUtils.isNotEmpty((CharSequence)builder.componentLocation));
        this.componentLocation = builder.componentLocation;
    }

    public static MetadataKeysExecutorBuilder newBuilder() {
        return new MetadataKeysExecutorBuilder();
    }

    @Override
    protected ServiceResponse<MetadataKeysContainer> doRunService(ToolingRequestContext context) {
        MetadataToolingService metadataService = context.getToolingApplication().getMetadataToolingService();
        try {
            MetadataResult<MetadataKeysContainer> result = metadataService.getMetadataKeys(this.componentLocation);
            if (result.isSuccess()) {
                return ServiceResponseFactory.from(result.isSuccess(), "", "", (MetadataKeysContainer)result.get());
            }
            List failure = result.getFailures();
            if (!failure.isEmpty()) {
                MetadataFailure metadataFailure = (MetadataFailure)failure.get(0);
                FailureCode failureCode = metadataFailure.getFailureCode();
                String message = failureCode.getValue();
                return ServiceResponseFactory.from(result.isSuccess(), message, metadataFailure.getReason(), (MetadataKeysContainer)result.get());
            }
            return ServiceResponseFactory.from(result.isSuccess(), "Unexpected error", "UNKNOWN", (MetadataKeysContainer)result.get());
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Datasense metadata types retrieval failed for global element ", (Throwable)e);
            return ServiceResponseFactory.failure(e);
        }
    }

    public static class MetadataKeysExecutorBuilder
    extends ToolingApplicationServiceExecutorTemplate.ToolingApplicationServiceExecutorTemplateBuilder<MetadataKeysContainer, MetadataKeysExecutorBuilder> {
        String componentLocation;

        public MetadataKeysServiceExecutor build() {
            return new MetadataKeysServiceExecutor(this);
        }

        public MetadataKeysExecutorBuilder componentLocation(String componentLocation) {
            this.componentLocation = componentLocation;
            return this.self();
        }

        @Override
        protected MetadataKeysExecutorBuilder self() {
            return this;
        }
    }
}

