/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.ToolingApplicationServiceExecutorTemplate;
import org.mule.tooling.client.ToolingRequestContext;
import org.mule.tooling.client.api.MetadataToolingService;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.core.MuleCorePlugin;

public class MetadataCacheEvictKeysServiceExecutor
extends ToolingApplicationServiceExecutorTemplate<Void> {
    private final String componentLocation;

    private MetadataCacheEvictKeysServiceExecutor(MetadataCacheEvictKeysServiceExecutorBuilder builder) {
        super(builder);
        assert (StringUtils.isNotEmpty((CharSequence)builder.componentLocation));
        this.componentLocation = builder.componentLocation;
    }

    public static MetadataCacheEvictKeysServiceExecutorBuilder newBuilder() {
        return new MetadataCacheEvictKeysServiceExecutorBuilder();
    }

    @Override
    protected ServiceResponse<Void> doRunService(ToolingRequestContext context) {
        MetadataToolingService metadataService = context.getToolingApplication().getMetadataToolingService();
        try {
            metadataService.evictMetadataKeysAt(this.componentLocation);
            return ServiceResponseFactory.success(null);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Datasense metadata types retrieval failed for global element ", (Throwable)e);
            return ServiceResponseFactory.failure(e);
        }
    }

    public static class MetadataCacheEvictKeysServiceExecutorBuilder
    extends ToolingApplicationServiceExecutorTemplate.ToolingApplicationServiceExecutorTemplateBuilder<Void, MetadataCacheEvictKeysServiceExecutorBuilder> {
        String componentLocation;

        public MetadataCacheEvictKeysServiceExecutor build() {
            return new MetadataCacheEvictKeysServiceExecutor(this);
        }

        public MetadataCacheEvictKeysServiceExecutorBuilder componentLocation(String componentLocation) {
            this.componentLocation = componentLocation;
            return this.self();
        }

        @Override
        protected MetadataCacheEvictKeysServiceExecutorBuilder self() {
            return this;
        }
    }
}

