/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.client.connection;

import com.mulesoft.mule.troubleshooting.client.connection.JMXConnection;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnectionException;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnectionFactory;
import com.mulesoft.mule.troubleshooting.client.connection.LocalPIDConnectionFactory;
import com.mulesoft.mule.troubleshooting.client.connection.MuleJMXBroadcastConnection;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MuleJMXBroadcastConnectionFactory
implements JMXConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger(MuleJMXBroadcastConnectionFactory.class);
    private final String scriptDir;

    public MuleJMXBroadcastConnectionFactory(Path scriptDir) {
        this.scriptDir = scriptDir.toString();
    }

    @Override
    public JMXConnection connect() throws JMXConnectionException {
        ArrayList<JMXConnection> connections = new ArrayList<JMXConnection>();
        for (VirtualMachineDescriptor vm : VirtualMachine.list()) {
            if (!vm.displayName().contains("MuleContainerBootstrap")) continue;
            try {
                VirtualMachine virtualMachine = VirtualMachine.attach(vm.id());
                String vmMuleHome = virtualMachine.getSystemProperties().getProperty("mule.home");
                LOGGER.info("Attached to MuleContainerBootstrap with id {} and mule.home: {}", (Object)vm.id(), (Object)vmMuleHome);
                virtualMachine.detach();
                if (vmMuleHome == null || !this.scriptDir.startsWith(vmMuleHome)) continue;
                connections.add(this.createLocalPIDConnectionFactory(vm.id()).connect());
                break;
            }
            catch (Exception e) {
                throw new JMXConnectionException("Error while analyzing connection " + vm.id(), e);
            }
        }
        if (connections.isEmpty()) {
            throw new JMXConnectionException("No mule found");
        }
        return new MuleJMXBroadcastConnection(connections);
    }

    protected LocalPIDConnectionFactory createLocalPIDConnectionFactory(String pid) {
        return new LocalPIDConnectionFactory(pid);
    }
}

