/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.client.connection;

import com.mulesoft.mule.troubleshooting.client.connection.ConnectionUtils;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnection;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnectionException;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnectionFactory;
import com.mulesoft.mule.troubleshooting.client.connection.SingleJMXConnection;
import com.sun.tools.attach.VirtualMachine;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalPIDConnectionFactory
implements JMXConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger(LocalPIDConnectionFactory.class);
    private static final String JMX_ADDRESS_PROPERTY = "com.sun.management.jmxremote.localConnectorAddress";
    private final String pid;

    public LocalPIDConnectionFactory(String pid) {
        this.pid = pid;
    }

    @Override
    public JMXConnection connect() throws JMXConnectionException {
        try {
            String address;
            LOGGER.info("Connecting to process: {}", (Object)this.pid);
            VirtualMachine virtualMachine = VirtualMachine.attach(this.pid);
            if (ConnectionUtils.IS_JAVA_8) {
                virtualMachine.loadAgent(ConnectionUtils.getManagementAgentPath());
            }
            if ((address = virtualMachine.getAgentProperties().getProperty(JMX_ADDRESS_PROPERTY)) == null) {
                virtualMachine.startLocalManagementAgent();
                address = virtualMachine.getAgentProperties().getProperty(JMX_ADDRESS_PROPERTY);
            }
            JMXServiceURL jmxUrl = new JMXServiceURL(address);
            SingleJMXConnection result = new SingleJMXConnection(JMXConnectorFactory.connect(jmxUrl));
            LOGGER.info("Successfully connected to: {}", (Object)this.pid);
            return result;
        }
        catch (Exception e) {
            throw new JMXConnectionException(String.format("Cannot connect to pid: %s", this.pid), e);
        }
    }
}

