/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.client;

import com.mulesoft.mule.troubleshooting.client.JmxOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class JmxOperations {
    private static final String TROUBLESHOOTING_BEAN_NAME = "com.mulesoft.mule.troubleshooting.plugin:type=com.mulesoft.mule.troubleshooting.plugin.mbean.Troubleshooting";
    private static final Logger LOGGER = LogManager.getLogger(JmxOperations.class);

    public static Object invokeMBean(MBeanServerConnection mBeanConnection, String methodName, Object[] params, String[] signatures) throws JmxOperationException {
        try {
            ObjectName filterName = new ObjectName(TROUBLESHOOTING_BEAN_NAME);
            Set<ObjectName> beanSet = mBeanConnection.queryNames(filterName, null);
            if (beanSet.isEmpty()) {
                LOGGER.debug("No MBean found with filter {}", () -> filterName);
                return null;
            }
            LOGGER.debug("MBeans found in domain java.lang:");
            ArrayList<Object> results = new ArrayList<Object>();
            for (ObjectName beanObjectName : beanSet) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = beanObjectName::toString;
                LOGGER.debug("MBeans returned: {}", supplierArray);
                Object result = mBeanConnection.invoke(beanObjectName, methodName, params, signatures);
                LOGGER.debug("MBean response: {}", result);
                results.add(result);
            }
            Object resultToReturn = null;
            if (results.size() == 1) {
                resultToReturn = results.get(0);
            }
            return resultToReturn;
        }
        catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new JmxOperationException("Error while invoking MBean", e);
        }
    }
}

