/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.client;

import com.mulesoft.mule.troubleshooting.client.JmxOperationException;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnection;
import com.mulesoft.mule.troubleshooting.client.connection.JMXConnectionException;
import com.mulesoft.mule.troubleshooting.client.connection.MuleJMXBroadcastConnectionFactory;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;

public class CommandLineInterface
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(CommandLineInterface.class);
    private static final String RETRIEVE_AVAILABLE_OPERATIONS = "retrieveAvailableOperations";
    private static final String EXECUTE_OPERATION = "executeOperation";
    private static final String EXECUTE_ALL_OPERATIONS = "executeAllOperations";
    private static final String THREAD_DUMP_OPERATION = "invokeThreadDump";
    private static final String HEAP_DUMP_OPERATION = "invokeHeapDump";
    private static final String DIAF_COMMAND = "diaf";
    private static final String LOGS_DIR_NAME = "logs";
    private static final String MULE_DUMP_FILE_NAME = "mule_dump_";
    private static final String THREAD_DUMP_FILE_NAME = "thread_dump_";
    private static final String CUSTOM_OUTPUT_PATH_PARAMETER_NAME = "--output";
    private static final String EXTENDED_MODE_PARAMETER_NAME = "--extended";
    private static final String HEAP_DUMP_PREFIX = "heap_dump_";
    private final JMXConnection connection;
    private final CommandLineParser parser = new DefaultParser();
    private final HelpFormatter formatter = new HelpFormatter();
    private final String commandName;
    private final Path scriptDir;
    private final List<String> cliArguments;
    private final String customOutputPath;
    private final boolean extendedMode;

    public CommandLineInterface(Path scriptDir, String[] args) throws JMXConnectionException {
        this(new MuleJMXBroadcastConnectionFactory(scriptDir).connect(), scriptDir, args);
    }

    CommandLineInterface(JMXConnection connection, Path scriptDir, String[] args) {
        this.connection = connection;
        this.scriptDir = scriptDir;
        this.cliArguments = new LinkedList<String>(Arrays.asList(args));
        this.extendedMode = this.cliArguments.remove(EXTENDED_MODE_PARAMETER_NAME);
        String outputPath = null;
        int outputIndex = this.cliArguments.indexOf(CUSTOM_OUTPUT_PATH_PARAMETER_NAME);
        if (outputIndex != -1 && outputIndex + 1 < this.cliArguments.size()) {
            this.cliArguments.remove(outputIndex);
            outputPath = this.cliArguments.remove(outputIndex);
        }
        this.customOutputPath = outputPath;
        this.commandName = this.cliArguments.isEmpty() ? DIAF_COMMAND : this.cliArguments.remove(0);
    }

    public void run() throws ParseException, JmxOperationException, IOException {
        List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions = this.getOperationDefinitions();
        if (DIAF_COMMAND.equals(this.commandName)) {
            LOGGER.info("Generating Mule Dump...");
            String diaf = this.invokeAllOperations(troubleshootingOperationDefinitions).toString();
            LOGGER.info("Diagnostic file successfully generated");
            String threadDump = this.invokeOperation(THREAD_DUMP_OPERATION).toString();
            LOGGER.info("Thread dump successfully generated");
            Path heapDumpPath = null;
            if (this.extendedMode) {
                String heapDumpPathStr = this.invokeOperation(HEAP_DUMP_OPERATION).toString();
                heapDumpPathStr = heapDumpPathStr.substring(1, heapDumpPathStr.length() - 1);
                heapDumpPath = Paths.get(heapDumpPathStr, new String[0]);
                LOGGER.info("Heap dump successfully generated at: {}", (Object)heapDumpPath);
            }
            this.createMuleDump(diaf, threadDump, heapDumpPath);
        } else {
            String result = this.invokeOperation(this.commandName, troubleshootingOperationDefinitions).toString();
            LOGGER.info("Operation '{}' successfully executed:\n{}", (Object)this.commandName, (Object)result);
        }
    }

    private List<TroubleshootingOperationDefinition> getOperationDefinitions() throws JmxOperationException, IOException {
        List operationDefinitions = (List)this.invokeOperation(RETRIEVE_AVAILABLE_OPERATIONS);
        if (operationDefinitions == null || operationDefinitions.isEmpty()) {
            throw new JmxOperationException("No Mule instances found");
        }
        if (operationDefinitions.size() > 1) {
            LOGGER.warn("Multiple Mule instances found, troubleshooting operations will be run only for the first one");
        }
        List result = (List)operationDefinitions.get(0);
        Collections.reverse(result);
        return result;
    }

    private Object invokeOperation(String operationName, List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions) throws JmxOperationException, IOException, ParseException {
        Map<String, String> argumentValues = this.getArgumentValues(operationName, troubleshootingOperationDefinitions);
        return this.connection.invoke(EXECUTE_OPERATION, new Object[]{operationName, argumentValues}, new String[]{String.class.getName(), Map.class.getName()});
    }

    private Object invokeOperation(String operationName) throws JmxOperationException, IOException {
        return this.connection.invoke(operationName, null, null);
    }

    private Object invokeAllOperations(List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions) throws JmxOperationException, IOException, ParseException {
        Map<String, String> argumentValues = this.getArgumentValues(troubleshootingOperationDefinitions);
        return this.connection.invoke(EXECUTE_ALL_OPERATIONS, new Object[]{argumentValues}, new String[]{Map.class.getName()});
    }

    private TroubleshootingOperationDefinition getOperation(String operationName, List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions) throws JmxOperationException {
        return troubleshootingOperationDefinitions.stream().filter(operation -> operation.getName().equals(operationName)).findFirst().orElseThrow(() -> new JmxOperationException("Operation " + operationName + " not found in any Mule instance"));
    }

    private Map<String, String> getArgumentValues(String operationName, List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions) throws JmxOperationException, ParseException {
        return this.getArgumentValues(Collections.singletonList(this.getOperation(operationName, troubleshootingOperationDefinitions)));
    }

    private Map<String, String> getArgumentValues(List<TroubleshootingOperationDefinition> troubleshootingOperationDefinitions) throws ParseException {
        HashMap<String, String> argumentValues = new HashMap<String, String>();
        ArrayList<String> definitionArgumentNames = new ArrayList<String>();
        Options options = new Options();
        for (TroubleshootingOperationDefinition operation : troubleshootingOperationDefinitions) {
            for (ArgumentDefinition argumentDefinition : operation.getArgumentDefinitions()) {
                String argumentName = argumentDefinition.getName();
                definitionArgumentNames.add(argumentName);
                Option option = new Option(String.valueOf(argumentName.charAt(0)), argumentName, true, argumentDefinition.getDescription());
                option.setRequired(argumentDefinition.isRequired());
                options.addOption(option);
            }
            try {
                CommandLine cmd = this.parser.parse(options, this.cliArguments.toArray(new String[0]), true);
                for (String argumentName : definitionArgumentNames) {
                    String argumentValue = (String)cmd.getParsedOptionValue(argumentName);
                    argumentValues.put(argumentName, argumentValue);
                }
            }
            catch (ParseException parseException) {
                this.formatter.printHelp(operation.getName(), options);
                throw parseException;
            }
        }
        return argumentValues;
    }

    private void createMuleDump(String diaf, String threadDump, Path heapDumpPath) throws IOException {
        long timestampMillis = System.currentTimeMillis();
        String diafFileName = MULE_DUMP_FILE_NAME + timestampMillis + ".diaf";
        String threadDumpFileName = THREAD_DUMP_FILE_NAME + timestampMillis + ".txt";
        String heapDumpFileName = heapDumpPath != null ? HEAP_DUMP_PREFIX + timestampMillis + ".hprof" : null;
        Path directoryPath = this.customOutputPath != null ? Paths.get(this.customOutputPath, new String[0]).toAbsolutePath() : this.scriptDir.getParent().resolve(LOGS_DIR_NAME);
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Could not create output directory: " + directoryPath.toAbsolutePath(), e);
            }
        }
        Path diafFilePath = directoryPath.resolve(diafFileName);
        Files.write(diafFilePath, diaf.getBytes(), new OpenOption[0]);
        LOGGER.info("DIAF file written: {}", (Object)diafFilePath.toAbsolutePath());
        Path threadDumpFilePath = directoryPath.resolve(threadDumpFileName);
        Files.write(threadDumpFilePath, threadDump.getBytes(), new OpenOption[0]);
        LOGGER.info("Thread dump file written: {}", (Object)threadDumpFilePath.toAbsolutePath());
        if (heapDumpPath != null) {
            Path heapDumpFilePath = directoryPath.resolve(heapDumpFileName);
            Files.copy(heapDumpPath, heapDumpFilePath, new CopyOption[0]);
            Files.delete(heapDumpPath);
            LOGGER.info("Heap dump file written: {}", (Object)heapDumpFilePath.toAbsolutePath());
        }
        LOGGER.info("Mule dump files written to directory: {}", (Object)directoryPath.toAbsolutePath());
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }
}

