/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.client;

import com.mulesoft.mule.troubleshooting.client.CommandLineInterface;
import com.mulesoft.mule.troubleshooting.client.connection.ConnectionUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Client {
    private static final Logger LOGGER = LogManager.getLogger(Client.class);

    public static void main(String[] args) throws Exception {
        LOGGER.info("Starting the troubleshooting client");
        if (ConnectionUtils.IS_JAVA_8) {
            Client.addToolsJarToClassloader();
        }
        Path scriptDir = Paths.get(args[0], new String[0]).toRealPath(new LinkOption[0]).normalize();
        String[] commandArgs = new String[args.length - 1];
        System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
        try (CommandLineInterface commandLineInterface = new CommandLineInterface(scriptDir, commandArgs);){
            commandLineInterface.run();
        }
    }

    public static void addToolsJarToClassloader() throws Exception {
        Path toolsJar = Paths.get(System.getProperty("java.home"), new String[0]).getParent().resolve("lib" + File.separator + "tools.jar");
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), toolsJar.toUri().toURL());
    }
}

