/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class LoggingExporterConfigurationUtils {
    public static void enableBackoffStrategy(Object exporterBuilder, ObservabilitySignalConfiguration configuration) {
        try {
            Field delegateField = exporterBuilder.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Method setRetryPolicyMethod = delegateField.get(exporterBuilder).getClass().getDeclaredMethod("setRetryPolicy", RetryPolicy.class);
            setRetryPolicyMethod.setAccessible(true);
            setRetryPolicyMethod.invoke(delegateField.get(exporterBuilder), new RetryPolicyBuilder(configuration).build());
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)new IllegalArgumentException("Unable to set the RetryPolicy reflectively.", e));
        }
    }

    public static void enableLatestHealthMetrics(Object exporterBuilder) {
        if (LoggingExporterConfigurationUtils.isHealthMetricsEnabled()) {
            try {
                Field delegateField = exporterBuilder.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Method setInternalTelemetryVersion = delegateField.get(exporterBuilder).getClass().getDeclaredMethod("setInternalTelemetryVersion", InternalTelemetryVersion.class);
                setInternalTelemetryVersion.setAccessible(true);
                setInternalTelemetryVersion.invoke(delegateField.get(exporterBuilder), InternalTelemetryVersion.LATEST);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)new IllegalArgumentException("Unable to set the Latest Health Metrics reflectively.", e));
            }
        }
    }

    public static boolean isHealthMetricsEnabled() {
        return Boolean.parseBoolean(System.getProperty("mule.enable.otel.exporters.health.metrics", "true"));
    }

    private record RetryPolicyBuilder(ObservabilitySignalConfiguration configuration) {
        public RetryPolicy build() {
            return RetryPolicy.builder().setBackoffMultiplier(this.configuration.getDoubleValue("mule.openTelemetry.logging.exporter.backoff.multiplier").doubleValue()).setInitialBackoff(this.configuration.getSecondsDurationValue("mule.openTelemetry.logging.exporter.backoff.initial")).setMaxBackoff(this.configuration.getSecondsDurationValue("mule.openTelemetry.logging.exporter.backoff.maximum")).setMaxAttempts(this.configuration.getIntValue("mule.openTelemetry.logging.exporter.backoff.maxAttempts").intValue()).build();
        }
    }
}

