/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.exception;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.common.util.Throwables;
import org.mule.munit.remote.exception.DeploymentException;

public class DeploymentExceptionThrower {
    private static final String DEPLOYMENT_EXCEPTION_CANONICAL_NAME = "org.mule.runtime.deployment.model.api.DeploymentException";

    public static void throwIfMatches(RuntimeException e) throws DeploymentException, RuntimeException {
        Preconditions.checkNotNull(e, "The exception must no be null");
        List<Throwable> deploymentExceptions = DeploymentExceptionThrower.findCauses(e);
        if (!deploymentExceptions.isEmpty()) {
            throw new DeploymentException(deploymentExceptions.get(0));
        }
        throw e;
    }

    private static List<Throwable> findCauses(Throwable e) {
        List<Throwable> causalChain = Throwables.getCausalChain(e);
        return causalChain.stream().filter(DeploymentExceptionThrower::isDeploymentException).collect(Collectors.toList());
    }

    public static boolean isDeploymentException(Throwable t) {
        if (t == null) {
            return false;
        }
        try {
            Class<?> deploymentExceptionClass = Class.forName(DEPLOYMENT_EXCEPTION_CANONICAL_NAME, false, t.getClass().getClassLoader());
            return deploymentExceptionClass.isInstance(t);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

