/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.printer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.mule.munit.common.util.Preconditions;

public class ReportFileWriter {
    public String getHtmlFileName(String resourceName) {
        String htmlFileName = resourceName;
        htmlFileName = htmlFileName.substring(0, htmlFileName.indexOf(".xml")) + "-report.html";
        return htmlFileName;
    }

    public void writeToFile(File file, String content) throws IOException {
        Preconditions.checkNotNull(file, "File cannot be null");
        file.getParentFile().mkdirs();
        file.createNewFile();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write(content);
        bw.flush();
        bw.close();
        ((Writer)writer).close();
    }

    public void copyFile(String originPath, File destination) throws IOException {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(originPath);
        FileUtils.copyInputStreamToFile(resource, destination);
    }
}

