/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mule.munit.remote.MinMuleVersionConfig;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.DebuggerConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;

public class RunConfiguration {
    private String runToken;
    private String projectName;
    private String domainLocation;
    private Set<String> tags;
    private Set<String> testNames;
    private List<Test> testNamesWithSuite;
    private Set<String> suitePaths;
    private Set<String> allSuitePaths;
    private Boolean skipAfterFailure;
    private List<String> mmvs;
    private MinMuleVersionConfig minMuleVersionConfig;
    private List<NotifierConfiguration> notifierConfigurations;
    private CoverageConfiguration coverageConfiguration;
    private ContainerConfiguration containerConfiguration;
    private DebuggerConfiguration debuggerConfiguration;
    private Boolean clearParameters;
    private String runtimeLocalDistribution;

    protected RunConfiguration(String runToken, String domainLocation, String projectName, Set<String> tags, Set<String> testNames, List<Test> testNamesWithSuite, Set<String> suitePaths, Set<String> allSuitePaths, Boolean skipAfterFailure, List<NotifierConfiguration> notifierConfigurations, CoverageConfiguration coverageConfiguration, ContainerConfiguration containerConfiguration, DebuggerConfiguration debuggerConfiguration, Boolean clearParameters, List<String> mmvs, MinMuleVersionConfig minMuleVersionConfig, String runtimeLocalDistribution) {
        this.runToken = runToken;
        this.domainLocation = domainLocation;
        this.projectName = projectName;
        this.tags = tags;
        this.testNames = testNames;
        this.testNamesWithSuite = testNamesWithSuite;
        this.suitePaths = suitePaths;
        this.allSuitePaths = allSuitePaths;
        this.skipAfterFailure = skipAfterFailure;
        this.notifierConfigurations = notifierConfigurations;
        this.coverageConfiguration = coverageConfiguration;
        this.containerConfiguration = containerConfiguration;
        this.debuggerConfiguration = debuggerConfiguration;
        this.clearParameters = clearParameters;
        this.mmvs = mmvs;
        this.minMuleVersionConfig = minMuleVersionConfig;
        this.runtimeLocalDistribution = runtimeLocalDistribution;
    }

    public RunConfiguration() {
    }

    public String getRunToken() {
        return this.runToken;
    }

    public String getDomainLocation() {
        return this.domainLocation;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getTestNames() {
        return this.testNames;
    }

    public List<Test> getTestNamesWithSuite() {
        return this.testNamesWithSuite;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public Set<String> getAllSuitePaths() {
        return this.allSuitePaths;
    }

    public Boolean isSkipAfterFailure() {
        return this.skipAfterFailure;
    }

    public List<NotifierConfiguration> getNotifierConfigurations() {
        return this.notifierConfigurations;
    }

    public CoverageConfiguration getCoverageConfiguration() {
        return this.coverageConfiguration;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public DebuggerConfiguration getDebuggerConfiguration() {
        return this.debuggerConfiguration;
    }

    public Boolean getClearParameters() {
        return this.clearParameters;
    }

    public List<String> getMmvs() {
        return this.mmvs;
    }

    public MinMuleVersionConfig getMinMuleVersionConfig() {
        return this.minMuleVersionConfig;
    }

    public void setMinMuleVersionConfig(MinMuleVersionConfig minMuleVersionConfig) {
        this.minMuleVersionConfig = minMuleVersionConfig;
    }

    public void setClearParameters(Boolean clearParameters) {
        this.clearParameters = clearParameters;
    }

    public String getRuntimeLocalDistribution() {
        return this.runtimeLocalDistribution;
    }

    public static class RunConfigurationBuilder {
        private String runToken;
        private String projectName;
        private String domainLocation;
        private Set<String> tags;
        private Set<String> testNames;
        private List<Test> testNamesWithSuite;
        private Set<String> suitePaths;
        private Set<String> allSuitePaths;
        private Boolean skipAfterFailure;
        private Boolean clearParameters;
        private List<String> mmvs;
        private MinMuleVersionConfig minMuleVersionConfig;
        private List<NotifierConfiguration> notifierConfigurations;
        private CoverageConfiguration coverageConfiguration;
        private ContainerConfiguration containerConfiguration;
        private DebuggerConfiguration debuggerConfiguration;
        private String runtimeLocalDistribution;

        public static RunConfigurationBuilder from(RunConfiguration rc) {
            RunConfigurationBuilder builder = new RunConfigurationBuilder();
            builder.withRunToken(rc.getRunToken()).withDomainLocation(rc.getDomainLocation()).withProjectName(rc.getProjectName()).withTags(rc.getTags()).withTestNames(rc.getTestNames()).withTestNamesWithSuite(rc.getTestNamesWithSuite()).withSuitePaths(rc.getSuitePaths()).withAllSuitePaths(rc.getAllSuitePaths()).withSkipAfterFailure(rc.isSkipAfterFailure()).withNotifierConfigurations(rc.getNotifierConfigurations()).withCoverageConfiguration(rc.getCoverageConfiguration()).withContainerConfiguration(rc.getContainerConfiguration()).withDebuggerConfiguration(rc.getDebuggerConfiguration()).withClearParameters(rc.getClearParameters()).withMmvs(rc.getMmvs()).withMinMuleVersionConfig(rc.getMinMuleVersionConfig()).withRuntimeLocalDistribution(rc.getRuntimeLocalDistribution());
            return builder;
        }

        public RunConfigurationBuilder withRunToken(String runToken) {
            this.runToken = runToken;
            return this;
        }

        public RunConfigurationBuilder withMmvs(List<String> mmvs) {
            this.mmvs = mmvs;
            return this;
        }

        public RunConfigurationBuilder withDomainLocation(String domainLocation) {
            this.domainLocation = domainLocation;
            return this;
        }

        public RunConfigurationBuilder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public RunConfigurationBuilder withTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public RunConfigurationBuilder withTestNames(Set<String> testNames) {
            this.testNames = testNames;
            return this;
        }

        public RunConfigurationBuilder withTestNamesWithSuite(List<Test> testNamesWithSuite) {
            this.testNamesWithSuite = testNamesWithSuite;
            return this;
        }

        public RunConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
            this.suitePaths = suitePaths;
            return this;
        }

        public RunConfigurationBuilder withAllSuitePaths(Set<String> allSuitePaths) {
            this.allSuitePaths = allSuitePaths;
            return this;
        }

        public RunConfigurationBuilder withSkipAfterFailure(Boolean skipAfterFailure) {
            this.skipAfterFailure = skipAfterFailure;
            return this;
        }

        public RunConfigurationBuilder withClearParameters(Boolean clearParameters) {
            this.clearParameters = clearParameters;
            return this;
        }

        public RunConfigurationBuilder withNotifierConfigurations(List<NotifierConfiguration> notifierConfigurations) {
            this.notifierConfigurations = notifierConfigurations;
            return this;
        }

        public RunConfigurationBuilder withCoverageConfiguration(CoverageConfiguration coverageConfiguration) {
            this.coverageConfiguration = coverageConfiguration;
            return this;
        }

        public RunConfigurationBuilder withContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public RunConfigurationBuilder withDebuggerConfiguration(DebuggerConfiguration debuggerConfiguration) {
            this.debuggerConfiguration = debuggerConfiguration;
            return this;
        }

        public RunConfigurationBuilder withMinMuleVersionConfig(MinMuleVersionConfig minMuleVersionConfig) {
            this.minMuleVersionConfig = minMuleVersionConfig;
            return this;
        }

        public RunConfigurationBuilder withRuntimeLocalDistribution(String runtimeLocalDistribution) {
            this.runtimeLocalDistribution = runtimeLocalDistribution;
            return this;
        }

        public RunConfiguration build() {
            return new RunConfiguration(this.runToken, this.domainLocation, this.projectName, this.tags, this.testNames, this.testNamesWithSuite, this.suitePaths, this.allSuitePaths, this.skipAfterFailure, this.notifierConfigurations, this.coverageConfiguration, this.containerConfiguration, this.debuggerConfiguration, this.clearParameters, this.mmvs, this.minMuleVersionConfig, this.runtimeLocalDistribution);
        }
    }

    public static final class Test {
        private final String suite;
        private final String name;

        public static Test of(String suite, String name) {
            return new Test(suite, name);
        }

        private Test(String suite, String name) {
            this.suite = suite;
            this.name = name;
        }

        public String getSuite() {
            return this.suite;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Test test = (Test)object;
            return Objects.equals(this.suite, test.suite) && Objects.equals(this.name, test.name);
        }

        public int hashCode() {
            return Objects.hash(this.suite, this.name);
        }
    }
}

