/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.pom;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.building.Source;
import org.apache.maven.building.UrlSource;
import org.apache.maven.model.building.ModelSource2;

public class UrlModelSource
implements ModelSource2 {
    private URL pomUrl;
    private Source pomSource;

    public UrlModelSource(URL pomUrl) {
        this.pomUrl = pomUrl;
        this.pomSource = new UrlSource(pomUrl);
    }

    @Override
    public ModelSource2 getRelatedSource(String relPath) {
        return null;
    }

    @Override
    public URI getLocationURI() {
        try {
            return this.pomUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("pom has an invalid location URI");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection connection = this.pomUrl.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        return connection.getInputStream();
    }

    @Override
    public String getLocation() {
        return this.pomSource.getLocation();
    }
}

