/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.internal.util.FileUtils;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;

public class DefaultPomFileSupplierFactory
implements PomFileSupplierFactory {
    private static final char SEPARATOR = '~';

    @Override
    public Supplier<File> uncompressPomArtifactSupplier(File artifactFolder, BundleDescriptor artifactBundleDescriptor) {
        return () -> this.uncompressPomArtifactSupplier(artifactFolder.toPath(), artifactBundleDescriptor).get().toFile();
    }

    @Override
    public Supplier<File> compressedArtifactSupplier(File artifactFile, BundleDescriptor artifactBundleDescriptor, File temporaryFolder) {
        return () -> this.compressedArtifactSupplier(artifactFile.toPath(), artifactBundleDescriptor, temporaryFolder.toPath()).get().toFile();
    }

    @Override
    public Supplier<Path> uncompressPomArtifactSupplier(Path artifactFolder, BundleDescriptor artifactBundleDescriptor) {
        return () -> {
            String pathToPom = Paths.get("META-INF", "maven", artifactBundleDescriptor.getGroupId(), artifactBundleDescriptor.getArtifactId(), "pom.xml").toString();
            return artifactFolder.resolve(pathToPom);
        };
    }

    @Override
    public Supplier<Path> compressedArtifactSupplier(Path artifactFile, BundleDescriptor artifactBundleDescriptor, Path temporaryFolder) {
        return () -> {
            try {
                URL pomUrl = org.mule.maven.pom.parser.internal.util.FileUtils.getPomUrlFromJar(artifactFile);
                Optional<byte[]> pomContentOptional = FileUtils.loadFileContentFrom(pomUrl);
                byte[] pomBytes = pomContentOptional.orElseThrow(() -> new RuntimeException(String.format("No pom file found in %s", artifactFile)));
                StringBuilder path = new StringBuilder(128);
                path.append(artifactBundleDescriptor.getGroupId()).append('~');
                path.append(artifactBundleDescriptor.getArtifactId()).append('~');
                path.append(artifactBundleDescriptor.getBaseVersion() != null ? artifactBundleDescriptor.getBaseVersion() : artifactBundleDescriptor.getVersion());
                path.append(".pom");
                Path pomLocation = temporaryFolder.resolve(path.toString());
                Files.createDirectories(temporaryFolder, new FileAttribute[0]);
                Files.write(pomLocation, pomBytes, new OpenOption[0]);
                return pomLocation;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

