/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.render.WidthUtilities;

public class WidthLongestWordMaxCol
implements V2_Width {
    protected int max;
    protected int[] maxAr;

    public WidthLongestWordMaxCol(int max) {
        if (max < 3) {
            throw new IllegalArgumentException("maximum column width cannot be smaller than 3");
        }
        this.max = max;
    }

    public WidthLongestWordMaxCol(int[] maxAr) {
        if (maxAr == null) {
            throw new IllegalArgumentException("maximum array cannot be null");
        }
        for (int m : maxAr) {
            if (m == -1 || m >= 3) continue;
            throw new IllegalArgumentException("array contains maximum column width smaller than 3");
        }
        this.maxAr = maxAr;
    }

    @Override
    public int[] getColumnWidths(V2_AsciiTable table) {
        if (table == null) {
            return null;
        }
        if (this.maxAr != null && this.maxAr.length != table.getColumnCount()) {
            throw new IllegalArgumentException("maxAr length is not the same as rows in the table");
        }
        int[] ret = WidthUtilities.longestWord(table);
        for (int i = 0; i < ret.length; ++i) {
            if (this.max != 0) {
                if (ret[i] <= this.max) continue;
                ret[i] = this.max;
                continue;
            }
            if (this.maxAr == null || this.maxAr[i] == -1 || ret[i] <= this.maxAr[i]) continue;
            ret[i] = this.maxAr[i];
        }
        return ret;
    }
}

