/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.mule.tooling.ui.widgets.SquareButton;
import org.mule.tooling.ui.widgets.button.RadioButtonGroup;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.dialog.TitleAreaEditorDialog;
import org.mule.tooling.ui.widgets.table.MapTableComposite;
import org.mule.tooling.ui.widgets.tree.SelectAllFilteredTree;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.SilentRunner;

public class WidgetUtils {
    private static final LazyValue<LocalResourceManager> resources = new LazyValue(WidgetUtils::getLocalResourceManager);
    private static final FontDescriptor BOLD_FONT_DESCRIPTOR = FontDescriptor.createFrom((Font)JFaceResources.getDialogFont()).setStyle(1);
    private static final LazyValue<Font> BUTTON_BOLD_FONT = new LazyValue(() -> ((LocalResourceManager)resources.getOrCompute()).createFont(BOLD_FONT_DESCRIPTOR));
    private static final LazyValue<Color> INACTIVE_COLOR = new LazyValue(() -> ((LocalResourceManager)resources.getOrCompute()).createColor(new RGB(188, 188, 188)));
    private static final LazyValue<Color> INACTIVE_COLOR_FONT = new LazyValue(() -> ((LocalResourceManager)resources.getOrCompute()).createColor(new RGB(255, 255, 255)));
    private static final String LCL = "abcdefghijklmnopqrstuvwxyz";
    private static final String UCL = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String NUMS = "0123456789";
    private static final int EMPTY_TEXT = 0;
    private static final int EMPTY_SELECTION = 1;
    private static final int FILE_EXITS = 2;
    private static final int EMPTY_CHECKED = 3;

    private static LocalResourceManager getLocalResourceManager() {
        return new LocalResourceManager(JFaceResources.getResources((Display)WidgetUtils.getDisplay()));
    }

    public <T extends Composite> TitleAreaEditorDialog<T> createTitleEditorDialog(Class<T> editor, IDialogEditorPresenter<T> controller, String title, String message) {
        return new TitleAreaEditorDialog<T>(Display.getCurrent().getActiveShell(), editor, controller, title, message);
    }

    public static <T extends Composite> SimpleEditorDialog<T> createSimpleEditorDialog(Class<T> editor, ISimpleDialogEditorPresenter<T> controller) {
        return new SimpleEditorDialog<T>(Display.getCurrent().getActiveShell(), editor, controller);
    }

    public static <T extends Composite> SimpleEditorDialog<T> createSimpleEditorDialog(Class<T> editor, ISimpleDialogEditorPresenter<T> controller, String okLabel, String cancelLabel) {
        SimpleEditorDialog<T> dialog = new SimpleEditorDialog<T>(Display.getCurrent().getActiveShell(), editor, controller);
        dialog.setOkLabel(okLabel);
        dialog.setCancelLabel(cancelLabel);
        return dialog;
    }

    public <T extends Composite> T createPopupComposite(Composite parent, Class<T> compositeClazz) {
        try {
            Constructor<T> constructor = compositeClazz.getConstructor(Composite.class, Integer.TYPE);
            return (T)((Composite)constructor.newInstance(parent, 8));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T runSilentInAsyncUI(Callable<T> call, T defaultReturn) {
        ObjectHolder result = new ObjectHolder();
        WidgetUtils.requireDisplay().asyncExec(() -> {
            Object object2 = result.set(SilentRunner.run((Callable)call, (Object)defaultReturn));
        });
        return (T)result.get();
    }

    public static <T> T runSilentInSyncUI(Callable<T> call, T defaultReturn) {
        ObjectHolder result = new ObjectHolder();
        WidgetUtils.requireDisplay().syncExec(() -> result.set(SilentRunner.run((Callable)call, (Object)defaultReturn)));
        return (T)result.get();
    }

    public <T extends Control> T createComponentWithLabel(Class<T> klass, Composite parent, String text) {
        return this.createComponentWithLabel(klass, parent, text, 2048);
    }

    public <T extends Control> T createComponentWithLabelReadOnly(Class<T> klass, Composite parent, String text) {
        return this.createComponentWithLabel(klass, parent, text, 2056);
    }

    public <T extends Control> T createComponentWithLabel(Class<T> klass, Composite parent, String text, int flags) {
        return this.createComponentWithLabel(klass, parent, text, null, flags);
    }

    public Label createLabel(Composite parent, String label) {
        Label result = new Label(parent, 0);
        result.setText(label);
        return result;
    }

    public static Label label(Composite searchComposite, String text) {
        Label label = new Label(searchComposite, 0);
        label.setText(text);
        return label;
    }

    public Button createButton(Composite parent, String label, int flags) {
        Button result = new Button(parent, flags);
        result.setText(label);
        return result;
    }

    public static SquareButton createSquareButton(Composite buttons, String label, final Runnable runnable) {
        SquareButton button = new SquareButton(buttons, 0);
        ThemeUtils.setCssId((Object)button, "SquareButton");
        button.setFont((Font)BUTTON_BOLD_FONT.getOrCompute());
        button.setInactiveColors((Color)INACTIVE_COLOR.getOrCompute(), (Color)INACTIVE_COLOR.getOrCompute(), null, (Color)INACTIVE_COLOR_FONT.getOrCompute());
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                runnable.run();
            }
        });
        return button;
    }

    public RadioButtonGroup createRadioButtonGroup(Composite parent) {
        return new RadioButtonGroup(parent, b -> {});
    }

    public RadioButtonGroup createRadioButtonGroup(Composite parent, Consumer<Button> onButtonSelected) {
        return new RadioButtonGroup(parent, onButtonSelected);
    }

    public static void showException(String title, String msg) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void showException(String title, String msg, Throwable error) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                StringWriter sw = new StringWriter();
                try {
                    try (PrintWriter pw = new PrintWriter(sw);){
                        error.printStackTrace(pw);
                        String trace = sw.toString();
                        ArrayList<Status> childStatuses = new ArrayList<Status>();
                        String[] stringArray = trace.split(System.getProperty("line.separator"));
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            childStatuses.add(new Status(4, "org.mule.tooling.ui.widgets", line));
                            ++n2;
                        }
                        MultiStatus ms = new MultiStatus("org.mule.tooling.ui.widgets", 4, (IStatus[])childStatuses.toArray(new Status[0]), error.getLocalizedMessage(), error);
                        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg, (IStatus)ms);
                    }
                    if (sw == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (sw == null) throw throwable;
                    sw.close();
                    throw throwable;
                }
                sw.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Shell getShell() {
        Display display = WidgetUtils.getDisplay();
        return display != null ? display.getActiveShell() : null;
    }

    public static Shell getMainWindowShell() {
        IWorkbenchWindow activeWorkbenchWindow;
        Shell mainWindowShell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            mainWindowShell = activeWorkbenchWindow.getShell();
        }
        return mainWindowShell;
    }

    public static Display getDisplay() {
        IWorkbench workbench;
        if (Display.getDefault() != null) {
            return Display.getDefault();
        }
        if (Display.getCurrent() != null) {
            return Display.getCurrent();
        }
        if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && workbench.getDisplay() != null) {
            return workbench.getDisplay();
        }
        return null;
    }

    public static Display requireDisplay() {
        Display display = WidgetUtils.getDisplay();
        if (display == null) {
            throw new IllegalStateException("There was not able to get any display");
        }
        return display;
    }

    public GridLayout createNoBorderGridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout result = new GridLayout(numColumns, makeColumnsEqualWidth);
        result.marginHeight = 0;
        result.marginWidth = 0;
        result.horizontalSpacing = 0;
        result.verticalSpacing = 0;
        return result;
    }

    public MapTableComposite createTableForMap(Composite parent) {
        return new MapTableComposite(parent, 0, "Name", "Value");
    }

    public static void addDropDownHint(TableViewer tableViewer, int columnIndex, Predicate<Object> enablementPredicate) {
        tableViewer.getTable().addListener(42, event -> {
            TableItem tableItem;
            if (event.index == columnIndex && event.item instanceof TableItem && (tableItem = (TableItem)event.item).getData() != null && enablementPredicate.test(tableItem.getData())) {
                WidgetUtils.drawDropDownHint(tableItem, event.gc);
            }
        });
    }

    private static void drawDropDownHint(TableItem item, GC gc) {
        Rectangle bounds = item.getBounds(2);
        int x = bounds.x + bounds.width - 8;
        int y = bounds.y + bounds.height / 2;
        int triangleSize = 3;
        int[] trianglePoints = new int[]{x - triangleSize, y - triangleSize, x + triangleSize, y - triangleSize, x, y + triangleSize};
        gc.drawPolygon(trianglePoints);
    }

    public <T extends Control, U extends Composite> T createComponentWithLabel(Class<T> klass, U parent, String text, String description, int flags) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        Label label = new Label(parent, 8);
        GridData layoutData = new GridData(4, 1, false, false, 1, 1);
        layoutData.verticalIndent = 5;
        label.setText(text);
        if (description != null) {
            ControlDecoration controlDecoration = new ControlDecoration((Control)label, 131200);
            controlDecoration.setDescriptionText(description);
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        }
        label.setLayoutData((Object)layoutData);
        Control instance = null;
        try {
            Constructor<?>[] constructorArray = klass.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 2 && parameterTypes[0].isAssignableFrom(parent.getClass()) && parameterTypes[1].equals(Integer.TYPE)) {
                    instance = (Control)constructor.newInstance(parent, flags);
                }
                ++n2;
            }
            if (instance == null) {
                throw new IllegalArgumentException();
            }
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 5;
            instance.setLayoutData((Object)gridData);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TableViewer createTableViewer(Composite parent, String ... columns) {
        int style = 67586;
        Table table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        int index = 0;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(table, 16384, index);
            column.setText(columnName);
            tableColumns.add(column);
            ++index;
            ++n2;
        }
        WidgetUtils.autoResizeColumns(table);
        return new TableViewer(table);
    }

    public static void autoResizeColumns(final Tree tree) {
        final Composite parent2 = tree.getParent();
        final TreeColumn[] columns2 = tree.getColumns();
        parent2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent2.getClientArea();
                Point preferredSize = tree.computeSize(-1, -1);
                int scrollBarWidth = 35;
                int width = area.width - 2 * tree.getBorderWidth() - scrollBarWidth;
                if (preferredSize.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = tree.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                if (oldSize.x > area.width) {
                    TreeColumn[] treeColumnArray = columns2;
                    int n = columns2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn tableColumn = treeColumnArray[n2];
                        tableColumn.setWidth(width / columns2.length);
                        ++n2;
                    }
                    tree.setSize(width, area.height);
                } else {
                    tree.setSize(width, area.height);
                    TreeColumn[] treeColumnArray = columns2;
                    int n = columns2.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeColumn tableColumn = treeColumnArray[n3];
                        tableColumn.setWidth(width / columns2.length);
                        ++n3;
                    }
                }
            }
        });
    }

    public static void autoResizeColumns(final Table table) {
        final Composite parent2 = table.getParent();
        final TableColumn[] columns2 = table.getColumns();
        parent2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent2.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int scrollBarWidth = 35;
                int width = area.width - 2 * table.getBorderWidth() - scrollBarWidth;
                if (preferredSize.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > area.width) {
                    TableColumn[] tableColumnArray = columns2;
                    int n = columns2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn tableColumn = tableColumnArray[n2];
                        tableColumn.setWidth(width / columns2.length);
                        ++n2;
                    }
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    TableColumn[] tableColumnArray = columns2;
                    int n = columns2.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableColumn tableColumn = tableColumnArray[n3];
                        tableColumn.setWidth(width / columns2.length);
                        ++n3;
                    }
                }
            }
        });
    }

    public static TableViewerColumn createColumn(TableViewer tableViewer, String columnName, final Function<Object, String> labelProviderFunction) {
        return WidgetUtils.createColumn(tableViewer, columnName, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)labelProviderFunction.apply(element);
            }
        });
    }

    public static TableViewerColumn createColumn(TableViewer tableViewer, String columnName, CellLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider(labelProvider);
        column.getColumn().setText(columnName);
        column.getColumn().setResizable(true);
        return column;
    }

    public static Point getHintForLabel(Label label) {
        return WidgetUtils.getHintForControl((Control)label, label.getText().length());
    }

    public static Point getHintForControl(Control control, int length) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return new Point(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)length), Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1));
    }

    public static int getLinesHeightInPixels(Control control, int lines) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)lines);
    }

    public static int getLinesWidthInPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public static void addUndoAndRedoCapability(TextViewer textViewer) {
        TextViewerUndoManager undoManager = new TextViewerUndoManager(30);
        WidgetUtils.addUndoAndRedoCapability(textViewer, (IUndoManager)undoManager);
    }

    public static void addUndoAndRedoCapability(TextViewer textViewer, IUndoManager undoManager) {
        final boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        final HashMap<String, IAction> actions = new HashMap<String, IAction>();
        textViewer.setUndoManager(undoManager);
        undoManager.connect((ITextViewer)textViewer);
        WidgetUtils.createUndoAndRedoActions((ITextViewer)textViewer, actions);
        WidgetUtils.createContextMenu((Control)textViewer.getTextWidget(), actions);
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                WidgetUtils.updateActions(actions);
                if (this.isUndoKeyPress(e)) {
                    this.runAction(ITextEditorActionConstants.UNDO, actions);
                } else if (this.isRedoKeyPress(e)) {
                    this.runAction(ITextEditorActionConstants.REDO, actions);
                } else if (this.isContentAssistKeyPress(e)) {
                    this.runAction("content.assist", actions);
                }
            }

            private boolean isContentAssistKeyPress(KeyEvent e) {
                return e.keyCode == 32 && (e.stateMask & 0x40000) != 0;
            }

            private void runAction(String actionID, Map<String, IAction> actions2) {
                IAction action = actions2.get(actionID);
                if (action.isEnabled()) {
                    action.run();
                }
                WidgetUtils.updateActions(actions2);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                if (!isMac) {
                    return (e.stateMask & SWT.MOD1) > 0 && (e.keyCode == 121 || e.keyCode == 89);
                }
                return e.keyCode == 122 && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & 0x20000) != 0;
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                if (!isMac) {
                    return (e.stateMask & SWT.MOD1) > 0 && (e.keyCode == 122 || e.keyCode == 90);
                }
                return e.keyCode == 122 && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & 0x20000) == 0;
            }
        };
        textViewer.getTextWidget().addKeyListener(keyListener);
        textViewer.getTextWidget().addDisposeListener(event -> {
            StyledText textWidget = textViewer.getTextWidget();
            if (textWidget != null) {
                textWidget.removeKeyListener(keyListener);
                textWidget.getMenu().dispose();
            }
        });
    }

    private static void createUndoAndRedoActions(ITextViewer textViewer, Map<String, IAction> actions) {
        TextViewerAction action = new TextViewerAction(textViewer, 1);
        action.setText("&Undo");
        actions.put(ITextEditorActionConstants.UNDO, (IAction)action);
        action = new TextViewerAction(textViewer, 2);
        action.setText("&Redo");
        actions.put(ITextEditorActionConstants.REDO, (IAction)action);
        action = new TextViewerAction(textViewer, 4);
        action.setText("&Copy");
        actions.put(ITextEditorActionConstants.COPY, (IAction)action);
        action = new TextViewerAction(textViewer, 3);
        action.setText("Cu&t");
        actions.put(ITextEditorActionConstants.CUT, (IAction)action);
        action = new TextViewerAction(textViewer, 5);
        action.setText("&Paste");
        actions.put(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new TextViewerAction(textViewer, 7);
        action.setText("Select &All");
        actions.put(ITextEditorActionConstants.SELECT_ALL, (IAction)action);
        action = new TextViewerAction(textViewer, 8);
        action.setText("Shift Right");
        actions.put("ShiftRight", (IAction)action);
        action = new TextViewerAction(textViewer, 9);
        action.setText("Shift Left");
        actions.put("ShiftLeft", (IAction)action);
        action = new TextViewerAction(textViewer, 13);
        action.setText("Content Assist Proposals");
        actions.put("content.assist", (IAction)action);
    }

    private static void createContextMenu(Control control, Map<String, IAction> actions) {
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        ActionMenuListener listener = new ActionMenuListener(actions);
        manager.addMenuListener((IMenuListener)listener);
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        control.addDisposeListener(event -> manager.dispose());
    }

    private static void fillContextMenu(IMenuManager menu, Map<String, IAction> actions) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", actions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", actions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.appendToGroup("group.reorganize", actions.get("ShiftLeft"));
        menu.appendToGroup("group.reorganize", actions.get("ShiftRight"));
    }

    private static void updateActions(Map<String, IAction> actions) {
        for (IAction action : actions.values()) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    public static SimpleContentProposalProvider enableContentProposal(Control control) {
        String[] proposals;
        if (control instanceof Combo) {
            proposals = ((Combo)control).getItems();
        } else if (control instanceof Text) {
            proposals = new String[]{};
        } else {
            return null;
        }
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(proposals);
        proposalProvider.setFiltering(true);
        ContentProposalAdapter proposalAdapter = WidgetUtils.enableContentProposal(control, (IContentProposalProvider)proposalProvider);
        proposalAdapter.setPropagateKeys(true);
        proposalAdapter.setProposalAcceptanceStyle(2);
        return proposalProvider;
    }

    public static ContentProposalAdapter enableContentProposal(Control control, IContentProposalProvider proposalProvider) {
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)new Integer(32));
        char[] autoactivationChars = proposalProvider instanceof IContentAssistProcessor ? ((IContentAssistProcessor)proposalProvider).getCompletionProposalAutoActivationCharacters() : WidgetUtils.getAutoactivationChars();
        return WidgetUtils.enableContentProposal(control, proposalProvider, keyStroke, autoactivationChars);
    }

    public static ContentProposalAdapter enableContentProposal(Control control, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        ComboContentAdapter controlContentAdapter = null;
        if (control instanceof Combo) {
            controlContentAdapter = new ComboContentAdapter();
        } else if (control instanceof Text) {
            controlContentAdapter = new TextContentAdapter();
        } else {
            throw new RuntimeException("Only Combo and Text content proposals are supported");
        }
        ContentProposalAdapter proposalAdapter = new ContentProposalAdapter(control, (IControlContentAdapter)controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        proposalAdapter.setPropagateKeys(true);
        return proposalAdapter;
    }

    private static char[] getAutoactivationChars() {
        String delete = new String(new char[]{'\b'});
        String allChars = LCL + UCL + NUMS + delete;
        return allChars.toCharArray();
    }

    public static boolean isAnyDisposedOrNull(Widget ... widgets) {
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget == null || widget.isDisposed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addEmptyTextConstrain(final Text text, final String name, final IEditorMessageLogger logger) {
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (text.isEnabled()) {
                    WidgetUtils.this.validate(text, name, logger);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.validate(text, name, logger);
    }

    public void addEmptySelectionConstrain(ISelectionProvider type, String name, IEditorMessageLogger logger) {
        type.addSelectionChangedListener(event -> this.validate(type, name, logger));
        this.validate(type, name, logger);
    }

    private void validate(Text text, String name, IEditorMessageLogger logger) {
        if (StringUtils.isBlank((String)text.getText())) {
            logger.errorMessage(text, name + " can not be empty.", 0);
        } else {
            logger.okMessage(text, 0);
        }
    }

    private void validate(ISelectionProvider type, String name, IEditorMessageLogger logger) {
        if (type.getSelection().isEmpty()) {
            logger.errorMessage(type, name + " selection can not be empty.", 1);
        } else {
            logger.okMessage(type, 1);
        }
    }

    public void addFileNameUnique(final Text text, String name, final IFolder folder, final String prefix, final IEditorMessageLogger logger) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (text.isEnabled()) {
                    WidgetUtils.this.validate(text, text.getText(), prefix, folder, logger);
                }
            }
        });
        this.validate(text, text.getText(), prefix, folder, logger);
    }

    private void validate(Text text, String name, String prefix, IFolder folder, IEditorMessageLogger logger) {
        if (folder.getFile(name + "." + prefix).exists()) {
            logger.errorMessage(text, "File '" + name + "' already exits.", 2);
        } else {
            logger.okMessage(text, 2);
        }
    }

    public void applyEditorLayout(Group output) {
        GridLayout noBorderLayout = this.createNoBorderGridLayout(2, false);
        output.setLayout((Layout)noBorderLayout);
    }

    public void addEmptyCheckedConstrain(SelectAllFilteredTree<?> viewer, String name, IEditorMessageLogger logger) {
        viewer.getViewer().addCheckStateListener(event -> this.validate(viewer, name, logger));
        this.validate(viewer, name, logger);
    }

    private void validate(SelectAllFilteredTree<?> type, String name, IEditorMessageLogger logger) {
        if (type.getCheckedElements().length == 0) {
            logger.errorMessage(type, name + " no element was checked.", 3);
        } else {
            logger.okMessage(type, 3);
        }
    }

    public Text createText(Composite parent, String text) {
        Text result = new Text(parent, 2048);
        result.setText(text);
        return result;
    }

    public static Label createLabel(Composite parent, int style, int fontSize) {
        FontData[] fontData;
        Label label = new Label(parent, style);
        FontData[] fontDataArray = fontData = label.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight(fontSize);
            ++n2;
        }
        Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(e -> newFont.dispose());
        return label;
    }

    public static void setFontStyle(Control control, int style) {
        FontData fontData = control.getFont().getFontData()[0];
        Font font = new Font((Device)control.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), style));
        control.setFont(font);
        control.addDisposeListener(e -> font.dispose());
    }

    public static void setFontSize(Control control, int size) {
        FontData fontData = control.getFont().getFontData()[0];
        Font font = new Font((Device)control.getDisplay(), new FontData(fontData.getName(), size, fontData.getStyle()));
        control.setFont(font);
        control.addDisposeListener(e -> font.dispose());
    }

    public static int getCharsVisibleInText(Label text) {
        double charWidth = WidgetUtils.getAverageCharsWidth((Drawable)text);
        int textWidth = text.getParent().getBounds().width;
        return textWidth / (int)charWidth;
    }

    private static double getAverageCharsWidth(Drawable text) {
        GC gc = new GC(text);
        FontMetrics fm = gc.getFontMetrics();
        double charWidth = fm.getAverageCharacterWidth();
        gc.dispose();
        return charWidth;
    }

    public static void applyDialogWorkaroundForMacOS(Dialog dialog) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Point size = WidgetUtils.getShell().getSize();
                    WidgetUtils.getShell().setSize(size.x + 1, size.y + 1);
                }
            });
        }
    }

    private static final class ActionMenuListener
    implements IMenuListener {
        private final Map<String, IAction> actions;

        private ActionMenuListener(Map<String, IAction> actions) {
            this.actions = actions;
        }

        public void menuAboutToShow(IMenuManager mgr) {
            WidgetUtils.updateActions(this.actions);
            WidgetUtils.fillContextMenu(mgr, this.actions);
        }
    }
}

