/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import com.google.common.base.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.WidgetsActivator;
import org.mule.tooling.ui.widgets.theme.IStudioTheme;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.theme.StudioLightTheme;
import org.w3c.dom.css.CSSValue;

public final class ThemeUtils {
    public static final String STUDIO_LIGHT_THEME = "org.mule.tooling.ui.theme.light";
    public static final String STUDIO_DARK_THEME = "org.mule.tooling.ui.theme.dark";
    private static boolean silent = false;

    private ThemeUtils() {
    }

    public static IStudioTheme getCurrentTheme() {
        ITheme activeTheme;
        IThemeEngine themeEngine;
        Optional<IWorkbench> workbench = ThemeUtils.getWorkbench();
        if (workbench.isPresent() && (themeEngine = (IThemeEngine)((IWorkbench)workbench.get()).getService(IThemeEngine.class)) != null && (activeTheme = themeEngine.getActiveTheme()) != null && STUDIO_DARK_THEME.equals(activeTheme.getId())) {
            return StudioDarkTheme.getInstance();
        }
        return StudioLightTheme.getInstance();
    }

    public static String getCurrentThemeId() {
        return ThemeUtils.getCurrentTheme().getId();
    }

    public static void setCurrentTheme(String themeId) {
        IThemeEngine themeEngine;
        Optional<IWorkbench> workbench = ThemeUtils.getWorkbench();
        if (workbench.isPresent() && (themeEngine = (IThemeEngine)((IWorkbench)workbench.get()).getService(IThemeEngine.class)) != null) {
            themeEngine.setTheme(themeId, true);
        }
    }

    public static Optional<IWorkbench> getWorkbench() {
        IWorkbench workbench;
        block2: {
            workbench = null;
            try {
                workbench = PlatformUI.getWorkbench();
            }
            catch (IllegalStateException e) {
                if (silent) break block2;
                WidgetsActivator.logWarning("Trying to acquire workbench before it was available", e);
            }
        }
        return Optional.fromNullable((Object)workbench);
    }

    public static void beSilent() {
        silent = true;
    }

    public static Optional<IStylingEngine> getStylingEngine() {
        Optional<IWorkbench> workbench = ThemeUtils.getWorkbench();
        if (workbench.isPresent()) {
            return Optional.fromNullable((Object)((IStylingEngine)((IWorkbench)workbench.get()).getService(IStylingEngine.class)));
        }
        return Optional.absent();
    }

    public static void applyStylingTo(IFigure figure) {
        Optional<IStylingEngine> stylingEngine = ThemeUtils.getStylingEngine();
        if (stylingEngine.isPresent()) {
            ((IStylingEngine)stylingEngine.get()).style((Object)figure);
        }
    }

    public static boolean setCssId(Object widget, String id) {
        Optional<IStylingEngine> engine = ThemeUtils.getStylingEngine();
        if (engine.isPresent()) {
            ((IStylingEngine)engine.get()).setId(widget, id);
            return true;
        }
        return false;
    }

    public static boolean setCssClass(Object widget, String className) {
        Optional<IStylingEngine> engine = ThemeUtils.getStylingEngine();
        if (engine.isPresent()) {
            ((IStylingEngine)engine.get()).setClassname(widget, className);
            return true;
        }
        return false;
    }

    public static boolean setCssClassAndId(Object widget, String className, String id) {
        return ThemeUtils.setCssClass(widget, className) && ThemeUtils.setCssId(widget, id);
    }

    public static Color cssValueToColor(CSSValue value, CSSEngine engine) {
        return ThemeUtils.cssValueToColor(value, engine, Display.getCurrent());
    }

    public static Color cssValueToColor(CSSValue value, CSSEngine engine, Display display) {
        Assert.isNotNull((Object)display);
        try {
            return (Color)engine.convert(value, Color.class, (Object)display);
        }
        catch (Exception e) {
            WidgetsActivator.logError("Could not convert color: " + String.valueOf(value), e);
            return ColorConstants.red;
        }
    }

    public static Object getCssEngineImplementation(Display display) {
        return WidgetElement.getEngine((Display)display);
    }
}

