/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class TextAndDecorationLabelProviderDecorator
extends StyledCellLabelProvider {
    private final List<Pattern> patterns;
    private final LabelProvider decorated;

    public TextAndDecorationLabelProviderDecorator(LabelProvider decorated, List<Pattern> patterns) {
        this.patterns = patterns;
        this.decorated = decorated;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Image image = this.decorated.getImage(element);
        if (image != null) {
            cell.setImage(image);
        }
        StyledString styledString = this.getStyledText(element);
        cell.setText(styledString.getString());
        cell.setStyleRanges(styledString.getStyleRanges());
        super.update(cell);
    }

    private StyledString getStyledText(Object element) {
        StyledString styledString = null;
        String text = this.decorated.getText(element);
        if (StringUtils.isNotBlank((String)text)) {
            for (Pattern pattern : this.patterns) {
                Matcher matcher = pattern.matcher(text);
                if (!matcher.matches()) continue;
                styledString = this.getStyledString(matcher);
                break;
            }
        }
        if (styledString == null) {
            styledString = new StyledString(text != null ? text : "");
        }
        return styledString;
    }

    private StyledString getStyledString(Matcher parentsMatcher) {
        return new StyledString(parentsMatcher.group(1)).append(parentsMatcher.group(2), StyledString.DECORATIONS_STYLER);
    }
}

