/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.util.function.Supplier;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public abstract class SearchResultLabelProvider
extends StyledCellLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Supplier<String> searchTerm;
    private Font font;
    private StyledString.Styler boldStyler = new BoldStyler();
    private String match;

    public SearchResultLabelProvider(Supplier<String> searchTerm, Font font) {
        this.searchTerm = searchTerm;
        this.font = font;
    }

    public StyledString getStyledText(Object element) {
        int indexOfSearchTerm;
        String gavString = this.getText(element);
        String _searchBeforeTrim = this.searchTerm.get();
        String _searchTerm = _searchBeforeTrim.trim();
        if (_searchTerm.isEmpty()) {
            return new StyledString(gavString);
        }
        String[] words = _searchTerm.split("\\s+");
        if (Character.isWhitespace(_searchBeforeTrim.charAt(_searchBeforeTrim.length() - 1))) {
            words[words.length - 1] = words[words.length - 1] + " ";
        }
        int endIndex = (indexOfSearchTerm = this.nextMatch(words, gavString)) != -1 ? indexOfSearchTerm : gavString.length();
        StyledString styledString = new StyledString(gavString.substring(0, endIndex));
        while (indexOfSearchTerm != -1) {
            styledString.append(new StyledString(this.match, this.boldStyler));
            int searchTermEndIndex = indexOfSearchTerm + this.match.length();
            String remaining = gavString.substring(searchTermEndIndex);
            int nextRelativeIndexOfSearchTerm = this.nextMatch(words, remaining);
            boolean moreMatches = nextRelativeIndexOfSearchTerm != -1;
            int nextNonSearchEndIndex = moreMatches ? searchTermEndIndex + nextRelativeIndexOfSearchTerm : gavString.length();
            String nextNonSearch = gavString.substring(searchTermEndIndex, nextNonSearchEndIndex);
            styledString.append(new StyledString(nextNonSearch));
            int n = indexOfSearchTerm = moreMatches ? searchTermEndIndex + nextRelativeIndexOfSearchTerm : -1;
        }
        return styledString;
    }

    protected abstract String getText(Object var1);

    private int nextMatch(String[] searchTerms, String target) {
        this.match = null;
        int indexOf = Integer.MAX_VALUE;
        String targetLowercase = target.toLowerCase();
        String[] stringArray = searchTerms;
        int n = searchTerms.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            int thisIndex = targetLowercase.indexOf(string.toLowerCase());
            if (thisIndex != -1 && thisIndex < indexOf) {
                this.match = target.substring(thisIndex, thisIndex + string.length());
                indexOf = thisIndex;
            }
            ++n2;
        }
        return indexOf == Integer.MAX_VALUE ? -1 : indexOf;
    }

    public Image getImage(Object element) {
        return null;
    }

    private final class BoldStyler
    extends StyledString.Styler {
        private BoldStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = JFaceResources.getFontRegistry().getBold(SearchResultLabelProvider.this.font.getFontData()[0].getName());
        }
    }
}

