/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.mule.tooling.ui.widgets.util.IPopUpConsumer;
import org.mule.tooling.ui.widgets.util.OpenWindowRequest;
import org.mule.tooling.ui.widgets.util.PopUpConsumer;

public class PopUpManager {
    private static final String DISABLE_POPUPS_KEY = "org.mule.tooling.ui.widgets.disable_popups";
    private final PriorityQueue<OpenWindowRequest> windowsRequest = new PriorityQueue<OpenWindowRequest>(10, new Comparator<OpenWindowRequest>(){

        @Override
        public int compare(OpenWindowRequest o1, OpenWindowRequest o2) {
            if (o1.getPriority().ordinal() < o2.getPriority().ordinal()) {
                return -1;
            }
            return 1;
        }
    });
    private final IPopUpConsumer consumer;

    private PopUpManager() {
        boolean disablePopups = Boolean.parseBoolean(System.getProperty(DISABLE_POPUPS_KEY, Boolean.FALSE.toString()));
        if (!disablePopups) {
            this.consumer = new PopUpConsumer();
            this.consumer.setWindowsRequests(this.windowsRequest);
        } else {
            this.consumer = new NoOpPopupConsumer();
        }
    }

    public static PopUpManager getInstance() {
        return Singleton.instance;
    }

    public void openWindow(OpenWindowRequest request) {
        this.windowsRequest.offer(request);
        this.startConsumerIfNeeded();
    }

    private void startConsumerIfNeeded() {
        if (!this.consumer.isRunning()) {
            this.consumer.start();
        }
    }

    private static final class NoOpPopupConsumer
    implements IPopUpConsumer {
        private NoOpPopupConsumer() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void start() {
        }

        @Override
        public void setWindowsRequests(PriorityQueue<OpenWindowRequest> windowsRequest) {
        }

        @Override
        public boolean isRunning() {
            return true;
        }
    }

    private static class Singleton {
        private static final PopUpManager instance = new PopUpManager();

        private Singleton() {
        }
    }
}

