/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.util.PriorityQueue;
import java.util.concurrent.Semaphore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.util.IPopUpConsumer;
import org.mule.tooling.ui.widgets.util.OpenWindowRequest;

public class PopUpConsumer
implements Runnable,
IPopUpConsumer {
    private PriorityQueue<OpenWindowRequest> windowsRequest;
    private volatile boolean stopped = true;
    private Thread thread;

    @Override
    public void run() {
        while (!this.stopped) {
            long remainingWaitTime;
            OpenWindowRequest request = this.windowsRequest.peek();
            TimeWatch watch = new TimeWatch();
            while ((remainingWaitTime = request.getWaitForNextPopUp() - watch.time()) > 0L) {
                try {
                    Thread.sleep(Math.min(remainingWaitTime, 100L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                OpenWindowRequest newRequest = this.windowsRequest.peek();
                if (request == newRequest) continue;
                watch = new TimeWatch();
                request = newRequest;
            }
            this.showWindowAndWait(request);
            this.windowsRequest.remove(request);
            long previousRequestDelayUntilNext = request.getDelayUntilShowNextPopUp();
            request = this.windowsRequest.peek();
            if (request != null) {
                request.setWaitForNextPopUp(request.getWaitForNextPopUp() + previousRequestDelayUntilNext);
                continue;
            }
            this.stop();
        }
    }

    private void showWindowAndWait(OpenWindowRequest request) {
        Semaphore semaphore = new Semaphore(0);
        Display.getDefault().asyncExec(() -> {
            Window window = request.getWindow();
            window.create();
            window.getShell().addDisposeListener(e -> semaphore.release());
            window.setBlockOnOpen(true);
            window.open();
        });
        try {
            semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setWindowsRequests(PriorityQueue<OpenWindowRequest> windowsRequest) {
        this.windowsRequest = windowsRequest;
    }

    @Override
    public void start() {
        this.thread = new Thread((Runnable)this, this.getClass().getCanonicalName());
        this.stopped = false;
        this.thread.start();
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.thread.interrupt();
        this.thread = null;
    }

    @Override
    public boolean isRunning() {
        return !this.stopped;
    }

    private static final class TimeWatch {
        private final long starts = System.currentTimeMillis();

        private TimeWatch() {
        }

        public long time() {
            return System.currentTimeMillis() - this.starts;
        }
    }
}

