/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.mule.tooling.ui.widgets.util.ImageDecorator;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int MIDDLE = 4;
    private Image baseImage;
    private List<ImageDecorator> decoratorAndPositions = new ArrayList<ImageDecorator>();
    private Point imgSize;

    public OverlayImageIcon(Image baseImage, Image overlayImage, int location) {
        this.baseImage = baseImage;
        this.imgSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
        this.decoratorAndPositions.add(new ImageDecorator(overlayImage, location));
    }

    public OverlayImageIcon(Image baseImage) {
        this.baseImage = baseImage;
        this.imgSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
    }

    public void addDecoration(ImageDecorator decorator) {
        this.decoratorAndPositions.add(decorator);
    }

    public void addDecorations(List<ImageDecorator> decorators) {
        for (ImageDecorator imageDescriptor : decorators) {
            if (imageDescriptor == null) continue;
            this.addDecoration(imageDescriptor);
        }
    }

    public void addDecoration(ImageDescriptor descriptor, int position) {
        if (descriptor != null) {
            this.decoratorAndPositions.add(new ImageDecorator(descriptor, position));
        }
    }

    public void addDecorations(ImageDescriptor[] overlays) {
        int position = 0;
        while (position < overlays.length) {
            this.addDecoration(overlays[position], position);
            ++position;
        }
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        this.drawOverlays();
    }

    private void drawOverlays() {
        for (ImageDecorator overlayIcon : this.decoratorAndPositions) {
            this.drawOverlay(overlayIcon.getImageData(), overlayIcon.getPosition());
        }
    }

    private void drawOverlay(ImageData imageData, int location) {
        switch (location) {
            case 0: {
                this.drawImage(imageData, 0, 0);
                break;
            }
            case 1: {
                this.drawImage(imageData, this.imgSize.x - imageData.width, 0);
                break;
            }
            case 2: {
                this.drawImage(imageData, 0, this.imgSize.y - imageData.height);
                break;
            }
            case 3: {
                this.drawImage(imageData, this.imgSize.x - imageData.width, this.imgSize.y - imageData.height);
                break;
            }
            case 4: {
                this.drawImage(imageData, this.imgSize.x / 2 - imageData.width / 2, this.imgSize.y / 2 - imageData.height / 2);
            }
        }
    }

    protected Point getSize() {
        return this.imgSize;
    }
}

