/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import org.eclipse.jface.window.Window;
import org.mule.tooling.ui.widgets.listener.IOpenedWindowListener;
import org.mule.tooling.ui.widgets.util.WindowPriority;

public class OpenWindowRequest {
    private Window window;
    private IOpenedWindowListener listener;
    private WindowPriority priority;
    private long delayUntilShowNextPopUp;
    private long waitForNextPopUp;

    private OpenWindowRequest(Window window2, IOpenedWindowListener listener2, WindowPriority priority2, long delayUntilShowNextPopUp, long waitForNextPopUp) {
        this.window = window2;
        this.listener = listener2;
        this.priority = priority2;
        this.setDelayUntilShowNextPopUp(delayUntilShowNextPopUp);
        this.setWaitForNextPopUp(waitForNextPopUp);
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public IOpenedWindowListener getListener() {
        return this.listener;
    }

    public void setListener(IOpenedWindowListener listener) {
        this.listener = listener;
    }

    public WindowPriority getPriority() {
        return this.priority;
    }

    public void setPriority(WindowPriority priority) {
        this.priority = priority;
    }

    public long getDelayUntilShowNextPopUp() {
        return this.delayUntilShowNextPopUp;
    }

    public void setDelayUntilShowNextPopUp(long delayUntilShowNextPopUp) {
        this.delayUntilShowNextPopUp = delayUntilShowNextPopUp;
    }

    public long getWaitForNextPopUp() {
        return this.waitForNextPopUp;
    }

    public void setWaitForNextPopUp(long waitForNextPopUp) {
        this.waitForNextPopUp = waitForNextPopUp;
    }

    public static class OpenWindowRequestBuilder {
        private Window window;
        private IOpenedWindowListener listener = new IOpenedWindowListener(){

            @Override
            public void execute() {
            }
        };
        private WindowPriority priority = WindowPriority.NORMAL;
        private long delayUntilShowNextPopUp = 1000L;
        private long waitForNextPopUp = 1000L;

        public OpenWindowRequestBuilder setWindow(Window window) {
            this.window = window;
            return this;
        }

        public OpenWindowRequestBuilder setCallback(IOpenedWindowListener listener) {
            this.listener = listener;
            return this;
        }

        public OpenWindowRequestBuilder setPriority(WindowPriority priority) {
            this.priority = priority;
            return this;
        }

        public OpenWindowRequest build() {
            return new OpenWindowRequest(this.window, this.listener, this.priority, this.delayUntilShowNextPopUp, this.waitForNextPopUp);
        }

        public OpenWindowRequestBuilder setDelayUntilShowNextPopUp(long delayUntilShowNextPopUp) {
            this.delayUntilShowNextPopUp = delayUntilShowNextPopUp;
            return this;
        }

        public OpenWindowRequestBuilder setWaitForNextPopUp(long waitForNextPopUp) {
            this.waitForNextPopUp = waitForNextPopUp;
            return this;
        }
    }
}

