/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.WidgetsActivator;

public class LinkMessageDialog
extends MessageDialog {
    private String link;
    private String url;

    public LinkMessageDialog(Shell parentShell, String dialogTitle, String dialogMessage, int dialogImageType, int defaultIndex, String[] dialogButtonLabels, String linkText, String url) {
        super(parentShell, dialogTitle, null, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.link = linkText;
        this.url = url;
    }

    protected Control createCustomArea(Composite parent) {
        Link link = new Link(parent, 64);
        link.setText(this.link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(LinkMessageDialog.this.url));
                }
                catch (PartInitException e1) {
                    WidgetsActivator.logError("The external browser could not be initialized", e1);
                }
                catch (MalformedURLException e1) {
                    WidgetsActivator.logError("The url you are trying to visit is invalid", e1);
                }
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)link);
        return link;
    }
}

