/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.util;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FormLayoutUtils {
    public static FormDataHelper attach(Control control) {
        return new FormDataHelper(control);
    }

    public static void setFormLayout(Composite composite, int marginWidth, int marginHeight) {
        composite.setLayout((Layout)FormLayoutUtils.formLayout(marginWidth, marginHeight));
    }

    public static void setFormLayout(Composite composite) {
        FormLayoutUtils.setFormLayout(composite, 0, 0);
    }

    public static FormLayout formLayout() {
        return FormLayoutUtils.formLayout(0, 0);
    }

    public static FormLayout formLayout(int marginWidth, int marginHeight) {
        FormLayout layout = new FormLayout();
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        return layout;
    }

    public static Composite composite(Composite parent) {
        return FormLayoutUtils.composite(parent, 0, 0);
    }

    public static Composite composite(Composite parent, int marginHeight, int marginWidth) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)FormLayoutUtils.formLayout(marginWidth, marginHeight));
        return composite;
    }

    public static class FormDataHelper {
        private static final int DENOMINATOR = 100;
        private final FormData formData = new FormData();
        private final Control targetControl;

        private FormDataHelper(Control control) {
            this.targetControl = control;
            this.targetControl.setLayoutData((Object)this.formData);
        }

        public FormDataHelper top(int denominator, int offset) {
            this.formData.top = new FormAttachment(denominator, -offset);
            return this;
        }

        public FormDataHelper top(int offset) {
            this.formData.top = new FormAttachment(0, offset);
            return this;
        }

        public FormDataHelper top() {
            return this.top(0);
        }

        public FormDataHelper topFrom(Control control, int offset) {
            this.formData.top = new FormAttachment(control, offset);
            return this;
        }

        public FormDataHelper left(int denominator, int offset) {
            this.formData.left = new FormAttachment(denominator, offset);
            return this;
        }

        public FormDataHelper left(int offset) {
            return this.left(0, offset);
        }

        public FormDataHelper left() {
            return this.left(0);
        }

        public FormDataHelper right(int denominator, int offset) {
            this.formData.right = new FormAttachment(denominator, -offset);
            return this;
        }

        public FormDataHelper right(int offset) {
            return this.right(100, offset);
        }

        public FormDataHelper right() {
            return this.right(0);
        }

        public FormDataHelper bottom() {
            return this.bottom(0);
        }

        public FormDataHelper bottom(int offset) {
            return this.bottom(100, offset);
        }

        public FormDataHelper bottom(int denominator, int offset) {
            this.formData.bottom = new FormAttachment(denominator, -offset);
            return this;
        }

        public FormDataHelper bottomFrom(Control control, int offset) {
            this.formData.bottom = new FormAttachment(control, -offset, 128);
            return this;
        }

        public FormDataHelper bottomFrom(Control control) {
            return this.bottomFrom(control, 0);
        }

        public FormDataHelper leftFrom(Control control, int offset) {
            this.formData.left = new FormAttachment(control, offset);
            return this;
        }

        public FormDataHelper rightFrom(Control control, int offset) {
            this.formData.right = new FormAttachment(control, -offset);
            return this;
        }

        public FormDataHelper alignMiddle(Control control) {
            this.formData.top = new FormAttachment(control, 0, 0x1000000);
            return this;
        }

        public FormDataHelper alignLeft(Control control) {
            this.formData.left = new FormAttachment(control, 0, 16384);
            return this;
        }

        public FormDataHelper alignBottom(Control control) {
            this.formData.bottom = new FormAttachment(control, 0, 1024);
            return this;
        }

        public FormDataHelper alignTop(Control control) {
            this.formData.top = new FormAttachment(control, 0, 128);
            return this;
        }

        public FormDataHelper preferredHeight(int height) {
            this.formData.height = height;
            return this;
        }

        public FormDataHelper preferredWidth(int width) {
            this.formData.width = width;
            return this;
        }
    }
}

