/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.treetable;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditor;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class TypedTreeEditorPresenter<T extends TypedTreeEditor, Y>
extends TreeTableEditorPresenter<T> {
    private TypesManager<Y> manager;

    public TypedTreeEditorPresenter(TypesManager<Y> manager) {
        this.manager = manager;
    }

    @Override
    protected void setColumsEditingSupport(T editor, TreeViewer treeViewer) {
        super.setColumsEditingSupport(editor, treeViewer);
        ((TypedTreeEditor)((Object)editor)).getTypeColumn().setLabelProvider((CellLabelProvider)new TypeElementNameLabelProvider());
        ((TypedTreeEditor)((Object)editor)).getTypeColumn().setEditingSupport((EditingSupport)new TypeElementEditingSupport((ColumnViewer)treeViewer));
    }

    @Override
    protected TreeTableElement createElementToAdd(String name) {
        return new TypedTableElement<Y>(new QName(name), this.manager.getTypes().get(0));
    }

    public TypesManager<Y> getManager() {
        return this.manager;
    }

    protected void updateTypedTableElement(TypedTableElement<Y> typedTableElement, ContentType<Y> contentType) {
        typedTableElement.setType(contentType);
    }

    public class TypeElementEditingSupport
    extends EditingSupport {
        public TypeElementEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            List types = TypedTreeEditorPresenter.this.manager.getTypes();
            String[] labels = new String[types.size()];
            int i = 0;
            while (i < types.size()) {
                labels[i] = types.get(i).getLabel();
                ++i;
            }
            ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)this.getViewer().getControl(), labels, 2056);
            editor.setActivationStyle(1);
            return editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            TypedTableElement e = (TypedTableElement)((Object)element);
            ContentType type = e.getType();
            List types = TypedTreeEditorPresenter.this.manager.getTypes();
            return types.indexOf(type);
        }

        protected void setValue(Object element, Object value) {
            Integer idx = (Integer)value;
            TypedTableElement typedTableElement = (TypedTableElement)((Object)element);
            List types = TypedTreeEditorPresenter.this.manager.getTypes();
            TypedTreeEditorPresenter.this.updateTypedTableElement(typedTableElement, types.get(idx));
            this.getViewer().update((Object)typedTableElement, null);
            TypedTreeEditorPresenter.this.notify(TreeTableEditorPresenter.EditorActions.MODIFY);
        }
    }

    public class TypeElementNameLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            TypedTableElement e = (TypedTableElement)((Object)element);
            return e.getType().getLabel();
        }
    }
}

