/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.treetable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;

public class TreeTableElement
extends TreeNode {
    private List<TreeTableElement> children = new ArrayList<TreeTableElement>();
    private QName qname;

    public TreeTableElement() {
        super((Object)UUID.randomUUID().toString());
    }

    public TreeTableElement(QName qname) {
        this();
        this.setQname(qname);
    }

    public void addChildren(Collection<? extends TreeTableElement> elements) {
        this.children.addAll(elements);
    }

    public void addChild(TreeTableElement child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void removeChild(TreeTableElement child) {
        if (this.children.remove((Object)child)) {
            child.setParent(null);
        }
    }

    public TreeTableElement getParent() {
        return (TreeTableElement)super.getParent();
    }

    public TreeTableElement[] getChildren() {
        return this.children.toArray(new TreeTableElement[this.children.size()]);
    }

    public void setChildren(TreeTableElement[] children) {
        this.children = new ArrayList<TreeTableElement>(Arrays.asList(children));
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getName() {
        return this.qname.getLocalPart();
    }

    public void setName(String name) {
        QName oldQName = this.qname;
        String prefix = oldQName != null ? oldQName.getPrefix() : null;
        String namespaceuri = oldQName != null ? oldQName.getNamespaceURI() : null;
        this.qname = new QName(namespaceuri, name, prefix);
    }

    public void setQname(QName qname) {
        this.qname = qname;
    }

    public QName getQname() {
        return this.qname;
    }

    public boolean supportChildrens() {
        return true;
    }

    public Image getImage() {
        return null;
    }
}

