/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.treetable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.widgets.treetable.IActionHandler;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorContentProvider;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;

public class TreeTableEditorPresenter<T extends TreeTableEditor> {
    private List<TreeTableEditorListener> listeners = new ArrayList<TreeTableEditorListener>();
    private List<TreeTableElement> elements;

    public TreeTableEditorPresenter() {
        this.setElements(new ArrayList<TreeTableElement>());
    }

    public void handle(T editor) {
        final TreeViewer treeViewer = ((TreeTableEditor)((Object)editor)).getTreeViewer();
        this.setColumsEditingSupport(editor, treeViewer);
        this.setActions(editor, treeViewer);
        treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter((TreeTableEditor)((Object)editor)){
            private final /* synthetic */ TreeTableEditor val$editor;
            {
                this.val$editor = treeTableEditor;
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && !treeViewer.getSelection().isEmpty()) {
                    this.val$editor.getRemoveElement().onActionPerform();
                    TreeTableEditorPresenter.this.notify(EditorActions.REMOVE);
                }
            }
        });
        treeViewer.setContentProvider((IContentProvider)new TreeTableEditorContentProvider());
        treeViewer.setInput(this.getElements());
        this.notify(EditorActions.LOAD);
        this.reload(treeViewer);
    }

    protected void setColumsEditingSupport(T editor, TreeViewer treeViewer) {
        ((TreeTableEditor)((Object)editor)).getNameColumn().setLabelProvider((CellLabelProvider)new ElementNameLabelProvider());
        ((TreeTableEditor)((Object)editor)).getNameColumn().setEditingSupport((EditingSupport)new TypeElementNameEditingSupport((ColumnViewer)treeViewer));
    }

    protected void setActions(T editor, TreeViewer treeViewer) {
        ((TreeTableEditor)((Object)editor)).setAddElement(this.createAddAction(treeViewer));
        ((TreeTableEditor)((Object)editor)).setRemoveElement(this.createRemoveAction(treeViewer));
        ((TreeTableEditor)((Object)editor)).setMoveUpElement(this.createMoveUpAction(treeViewer));
        ((TreeTableEditor)((Object)editor)).setMoveDownElement(this.createMoveDownAction(treeViewer));
    }

    protected void reload(TreeViewer treeViewer) {
        treeViewer.refresh();
    }

    protected IActionHandler createRemoveAction(final TreeViewer treeViewer) {
        return new IActionHandler(){

            @Override
            public void onActionPerform() {
                ISelection selection = treeViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object[] array;
                    StructuredSelection treeSelection = (StructuredSelection)selection;
                    Object[] objectArray = array = treeSelection.toArray();
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element2 = objectArray[n2];
                        TreeTableElement element = (TreeTableElement)((Object)element2);
                        TreeTableElement parent = element.getParent();
                        if (parent != null && !TreeTableEditorPresenter.this.getElements().contains((Object)element)) {
                            parent.removeChild(element);
                        } else {
                            TreeTableEditorPresenter.this.getElements().remove((Object)element);
                        }
                        ++n2;
                    }
                    TreeTableEditorPresenter.this.reload(treeViewer);
                    TreeTableEditorPresenter.this.notify(EditorActions.REMOVE);
                }
            }
        };
    }

    protected IActionHandler createMoveUpAction(final TreeViewer treeViewer) {
        return new IActionHandler(){

            @Override
            public void onActionPerform() {
                StructuredSelection selection = (StructuredSelection)treeViewer.getSelection();
                if (!selection.isEmpty() && TreeTableEditorPresenter.this.canMoveSelectedElements(selection)) {
                    TreeTableElement firstElement = (TreeTableElement)((Object)selection.getFirstElement());
                    TreeTableElement parent = firstElement.getParent();
                    if (parent != null) {
                        ArrayList<TreeTableElement> brothers = new ArrayList<TreeTableElement>(Arrays.asList(parent.getChildren()));
                        this.moveDownElement(selection, firstElement, brothers);
                        parent.setChildren(brothers.toArray(new TreeTableElement[brothers.size()]));
                    } else {
                        this.moveDownElement(selection, firstElement, TreeTableEditorPresenter.this.getElements());
                    }
                    TreeTableEditorPresenter.this.reload(treeViewer);
                    TreeTableEditorPresenter.this.notify(EditorActions.MOVE_UP);
                }
            }

            protected void moveDownElement(StructuredSelection selection, TreeTableElement firstElement, List<TreeTableElement> elements) {
                int indexOfFirstElement = elements.indexOf((Object)firstElement);
                if (indexOfFirstElement > 0) {
                    TreeTableElement previousElement = elements.get(indexOfFirstElement - 1);
                    elements.remove((Object)previousElement);
                    elements.add(indexOfFirstElement + selection.size() - 1, previousElement);
                }
            }
        };
    }

    protected IActionHandler createMoveDownAction(final TreeViewer treeViewer) {
        return new IActionHandler(){

            @Override
            public void onActionPerform() {
                StructuredSelection selection = (StructuredSelection)treeViewer.getSelection();
                if (!selection.isEmpty() && TreeTableEditorPresenter.this.canMoveSelectedElements(selection)) {
                    TreeTableElement firstElement = (TreeTableElement)((Object)selection.getFirstElement());
                    TreeTableElement parent = firstElement.getParent();
                    if (parent != null) {
                        ArrayList<TreeTableElement> brothers = new ArrayList<TreeTableElement>(Arrays.asList(parent.getChildren()));
                        this.moveDownElement(selection, firstElement, brothers);
                        parent.setChildren(brothers.toArray(new TreeTableElement[brothers.size()]));
                    } else {
                        this.moveDownElement(selection, firstElement, TreeTableEditorPresenter.this.getElements());
                    }
                    TreeTableEditorPresenter.this.reload(treeViewer);
                    TreeTableEditorPresenter.this.notify(EditorActions.MOVE_DOWN);
                }
            }

            protected void moveDownElement(StructuredSelection selection, TreeTableElement firstElement, List<TreeTableElement> elements) {
                int indexOfFirstElement = elements.indexOf((Object)firstElement);
                if (indexOfFirstElement + selection.size() < elements.size()) {
                    TreeTableElement postElement = elements.get(indexOfFirstElement + selection.size());
                    elements.remove((Object)postElement);
                    elements.add(indexOfFirstElement, postElement);
                }
            }
        };
    }

    protected boolean canMoveSelectedElements(StructuredSelection treeSelection) {
        TreeTableElement parent = ((TreeTableElement)((Object)treeSelection.getFirstElement())).getParent();
        Iterator iterator = treeSelection.iterator();
        while (iterator.hasNext()) {
            if (((TreeTableElement)((Object)iterator.next())).getParent() == parent) continue;
            return false;
        }
        return true;
    }

    protected IActionHandler createAddAction(TreeViewer treeViewer) {
        return this.doCreateAddAction(treeViewer, "field_");
    }

    protected IActionHandler doCreateAddAction(final TreeViewer treeViewer, final String fieldBaseName) {
        return new IActionHandler(){
            private int elementsNumber;
            {
                this.elementsNumber = TreeTableEditorPresenter.this.getElements().size();
            }

            @Override
            public void onActionPerform() {
                TreeTableElement element;
                int fieldNumber = this.elementsNumber++;
                StructuredSelection selection = (StructuredSelection)treeViewer.getSelection();
                boolean addToRoot = true;
                if (!selection.isEmpty() && (element = (TreeTableElement)((Object)selection.getFirstElement())).supportChildrens()) {
                    addToRoot = false;
                    fieldNumber = element.getChildren().length + 1;
                }
                String name = fieldBaseName + fieldNumber;
                TreeTableElement childElement = TreeTableEditorPresenter.this.createElementToAdd(name);
                if (addToRoot) {
                    TreeTableEditorPresenter.this.getElements().add(childElement);
                } else {
                    TreeTableElement element2 = (TreeTableElement)((Object)selection.getFirstElement());
                    QName parentQName = element2.getQname();
                    childElement.setQname(new QName(parentQName.getNamespaceURI(), name, parentQName.getPrefix()));
                    element2.addChild(childElement);
                }
                TreeTableEditorPresenter.this.reload(treeViewer);
                treeViewer.expandToLevel((Object)childElement, 1);
                TreeTableEditorPresenter.this.notify(EditorActions.ADD);
            }
        };
    }

    protected TreeTableElement createElementToAdd(String name) {
        return new TreeTableElement(new QName(name));
    }

    public void setElements(List<TreeTableElement> elements) {
        this.elements = elements;
    }

    public List<TreeTableElement> getElements() {
        return this.elements;
    }

    protected void notify(EditorActions action) {
        for (TreeTableEditorListener treeTableEditorListener : this.listeners) {
            treeTableEditorListener.actionPerformed(action);
        }
    }

    public void addListener(TreeTableEditorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TreeTableEditorListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean canEditElementName() {
        return true;
    }

    private static final class CustomTextCellEditor
    extends TextCellEditor {
        private int minHeight = 0;

        public CustomTextCellEditor(Composite parent, int style) {
            super(parent, style);
            Text text = (Text)this.getControl();
            Font font = text.getFont();
            FontData[] fontData = font.getFontData();
            if (fontData != null && fontData.length > 0) {
                this.minHeight = fontData[0].getHeight() + 7;
            }
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = super.getLayoutData();
            if (this.minHeight > 0) {
                data.minimumHeight = this.minHeight;
            }
            return data;
        }
    }

    public static enum EditorActions {
        ADD,
        REMOVE,
        MOVE_UP,
        MOVE_DOWN,
        LOAD,
        MODIFY;

    }

    public static class ElementNameLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            TreeTableElement e = (TreeTableElement)((Object)element);
            return e.getName() == null ? "<unknown>" : e.getName();
        }

        public Image getImage(Object element) {
            TreeTableElement e = (TreeTableElement)((Object)element);
            return e.getImage();
        }
    }

    public static interface TreeTableEditorListener {
        public void actionPerformed(EditorActions var1);
    }

    public class TypeElementNameEditingSupport
    extends EditingSupport {
        public TypeElementNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            return new CustomTextCellEditor((Composite)this.getViewer().getControl(), 2048);
        }

        protected boolean canEdit(Object element) {
            return TreeTableEditorPresenter.this.canEditElementName();
        }

        protected Object getValue(Object element) {
            TreeTableElement e = (TreeTableElement)((Object)element);
            return e.getName();
        }

        protected void setValue(Object element, Object value) {
            TreeTableElement e = (TreeTableElement)((Object)element);
            if (this.canEdit(element)) {
                e.setName(value.toString());
                this.getViewer().update((Object)e, null);
                TreeTableEditorPresenter.this.notify(EditorActions.MODIFY);
            }
        }
    }
}

