/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.treetable;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.treetable.IActionHandler;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorContentProvider;

public class TreeTableEditor
extends Composite {
    private TreeViewer treeViewer;
    private IActionHandler addElement;
    private IActionHandler removeElement;
    private IActionHandler moveUpElement;
    private IActionHandler moveDownElement;
    private TreeViewerColumn nameColumn;

    public TreeTableEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        MenuManager manager = new MenuManager();
        this.createToolBar(parent, manager);
        this.setTreeViewer(new TreeViewer(parent, 68354));
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().getTree().setHeaderVisible(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.getTreeViewer().getControl());
        this.addColumns();
        this.getTreeViewer().setContentProvider((IContentProvider)new TreeTableEditorContentProvider());
        this.getTreeViewer().getControl().setMenu(manager.createContextMenu(this.getTreeViewer().getControl()));
    }

    public void addActions(ToolBarManager toolManager, MenuManager manager) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new Action("Add", WidgetsImages.ADD_IMAGE){

            public void run() {
                TreeTableEditor.this.setFocus();
                TreeTableEditor.this.getAddElement().onActionPerform();
            }
        });
        actions.add(new Action("Remove", WidgetsImages.DELETE_IMAGE){

            public void run() {
                TreeTableEditor.this.setFocus();
                TreeTableEditor.this.getRemoveElement().onActionPerform();
            }
        });
        actions.add(new Action("Move Up", WidgetsImages.getImageDescriptor("icons/move_up_16x16.gif")){

            public void run() {
                TreeTableEditor.this.setFocus();
                TreeTableEditor.this.getMoveUpElement().onActionPerform();
            }
        });
        actions.add(new Action("Move Down", WidgetsImages.getImageDescriptor("icons/move_down_16x16.gif")){

            public void run() {
                TreeTableEditor.this.setFocus();
                TreeTableEditor.this.getMoveDownElement().onActionPerform();
            }
        });
        for (Action action : actions) {
            toolManager.add((IAction)action);
            manager.add((IAction)action);
        }
    }

    public void createToolBar(Composite parent, MenuManager manager) {
        ToolBarManager toolManager = new ToolBarManager();
        ToolBar bar = toolManager.createControl(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bar);
        this.addActions(toolManager, manager);
        toolManager.update(true);
    }

    public void addColumns() {
        this.setNameColumn(new TreeViewerColumn(this.getTreeViewer(), 0));
        this.getNameColumn().getColumn().setResizable(true);
        this.getNameColumn().getColumn().setText("Name");
        this.getNameColumn().getColumn().setWidth(200);
    }

    public void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setNameColumn(TreeViewerColumn nameColumn) {
        this.nameColumn = nameColumn;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void setAddElement(IActionHandler addElement) {
        this.addElement = addElement;
    }

    public IActionHandler getAddElement() {
        return this.addElement;
    }

    public void setRemoveElement(IActionHandler removeElement) {
        this.removeElement = removeElement;
    }

    public IActionHandler getRemoveElement() {
        return this.removeElement;
    }

    public void setMoveUpElement(IActionHandler moveUpElement) {
        this.moveUpElement = moveUpElement;
    }

    public IActionHandler getMoveUpElement() {
        return this.moveUpElement;
    }

    public void setMoveDownElement(IActionHandler moveDownElement) {
        this.moveDownElement = moveDownElement;
    }

    public IActionHandler getMoveDownElement() {
        return this.moveDownElement;
    }
}

