/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tree.model;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class GraphicalTreeNode<T> {
    private static final GraphicalTreeNode<?>[] EMPTY = new GraphicalTreeNode[0];
    private final int level;
    private T model;
    private Image icon;
    private String label;
    private String description;
    private Font font;
    private String prefix;
    private String suffix;
    private String id;
    private Color foreground = null;
    private GraphicalTreeNode<?> parent;
    private IGraphicalChildrenProvider<T> factory;

    public GraphicalTreeNode(String label, String description, T model, IGraphicalChildrenProvider<T> factory) {
        this(null, label, description, model, factory);
    }

    public GraphicalTreeNode(GraphicalTreeNode<?> parent, String label, String description, T model, IGraphicalChildrenProvider<T> factory) {
        this.description = description;
        this.model = model;
        this.label = label;
        this.factory = factory;
        this.parent = parent;
        this.level = parent != null ? parent.getLevel() + 1 : 0;
    }

    public int getLevel() {
        return this.level;
    }

    public T getModel() {
        return this.model;
    }

    public GraphicalTreeNode<?>[] getChildren(int maxRecursionLevel) {
        if (this.getLevel() >= maxRecursionLevel) {
            return EMPTY;
        }
        if (this.model instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)this.model).getChildren(maxRecursionLevel);
        }
        GraphicalTreeNode<?>[] childrenArray = EMPTY;
        if (this.factory != null) {
            List<GraphicalTreeNode<?>> children = this.factory.getChildren(this);
            childrenArray = children.toArray(new GraphicalTreeNode[children.size()]);
        }
        return childrenArray;
    }

    public GraphicalTreeNode<T> markError(String errorMessage) {
        this.icon(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        this.description = errorMessage;
        return this;
    }

    public GraphicalTreeNode<T> markWarning(String warningMessage) {
        this.icon(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.description = warningMessage;
        return this;
    }

    public GraphicalTreeNode<T> foreground(Color foregound) {
        this.foreground = foregound;
        return this;
    }

    public GraphicalTreeNode<T> font(Font font) {
        this.font = font;
        return this;
    }

    public GraphicalTreeNode<T> id(String id) {
        this.id = id;
        return this;
    }

    public GraphicalTreeNode<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public GraphicalTreeNode<T> suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public GraphicalTreeNode<T> icon(Image icon) {
        this.icon = icon;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    public GraphicalTreeNode<?> getParent() {
        return this.parent;
    }

    public String toString() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + this.level;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphicalTreeNode other = (GraphicalTreeNode)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String getSuffix() {
        return this.suffix;
    }
}

