/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tree.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class GraphicalTreeLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider {
    private static final String COLON = ":";
    public static final Color GRAY = Display.getCurrent().getSystemColor(16);
    public static final Color LIGHT_GRAY = Display.getCurrent().getSystemColor(15);
    private static final StyledString.Styler SUFFIX_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
    };

    public GraphicalTreeLabelProvider() {
    }

    public GraphicalTreeLabelProvider(int style) {
        super(style);
    }

    public Font getFont(Object element) {
        return ((GraphicalTreeNode)element).getFont();
    }

    public Color getForeground(Object element) {
        return ((GraphicalTreeNode)element).getForeground();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)element).getIcon();
        }
        return null;
    }

    public String getToolTipText(Object element) {
        if (element instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)element).getDescription();
        }
        return super.getToolTipText(element);
    }

    public boolean useNativeToolTip(Object object) {
        return false;
    }

    public String getText(Object element) {
        if (element instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)element).getLabel();
        }
        return String.valueOf(element);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setImage(this.getImage(element));
        StyledString styledString = new StyledString();
        if (element instanceof GraphicalTreeNode) {
            this.renderText(cell, styledString, (GraphicalTreeNode)element);
        }
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setText(styledString.getString());
        super.update(cell);
    }

    protected void renderText(ViewerCell cell, StyledString styledString, GraphicalTreeNode<?> element) {
        String suffix;
        String text = this.getText(element);
        StyledString.Styler dataStyler = this.getDataStyle(cell);
        String prefix = this.getPrefix(element);
        if (StringUtils.isNotBlank((String)prefix)) {
            StyledString.Styler typeStyler = this.getPrefixStyle();
            styledString.append(prefix + " ", typeStyler);
        }
        String label = text = text != null ? text : "";
        String typeData = null;
        if (text.contains(COLON)) {
            int lastIndexOfColom = text.lastIndexOf(COLON);
            typeData = text.substring(lastIndexOfColom + 1);
            label = text.substring(0, lastIndexOfColom + 1);
        }
        styledString.append(label, dataStyler);
        if (StringUtils.isNotBlank(typeData)) {
            StyledString.Styler typeStyler = this.getDataTypeStyle(cell);
            styledString.append(typeData, typeStyler);
        }
        if (StringUtils.isNotBlank((String)(suffix = this.getSuffix(element))) && element instanceof GraphicalTreeNode) {
            StyledString.Styler typeStyler = this.getSuffixStyle(element);
            styledString.append(" = ");
            styledString.append(suffix, typeStyler);
        }
    }

    private String getSuffix(Object element) {
        if (element instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)element).getSuffix();
        }
        return null;
    }

    private String getPrefix(Object element) {
        if (element instanceof GraphicalTreeNode) {
            return ((GraphicalTreeNode)element).getPrefix();
        }
        return null;
    }

    protected StyledString.Styler getPrefixStyle() {
        return SUFFIX_STYLER;
    }

    protected StyledString.Styler getSuffixStyle(GraphicalTreeNode<?> element) {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = LIGHT_GRAY;
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        };
    }

    protected StyledString.Styler getDataStyle(ViewerCell cell) {
        final Object element = cell.getElement();
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = GraphicalTreeLabelProvider.this.getForeground(element);
                textStyle.background = GraphicalTreeLabelProvider.this.getBackground(element);
                textStyle.font = GraphicalTreeLabelProvider.this.getFont(element);
            }
        };
    }

    protected StyledString.Styler getDataTypeStyle(ViewerCell cell) {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = GRAY;
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        };
    }
}

