/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.mule.tooling.ui.widgets.tree.NameProvidingFunction;

class TreeModel<T> {
    private List<TreeModelNode<T>> rootNodes = new ArrayList<TreeModelNode<T>>();
    private NameProvidingFunction<T> nameProvidingFunction;

    public TreeModel(NameProvidingFunction<T> nameProvidingFunction) {
        this.nameProvidingFunction = nameProvidingFunction;
    }

    public void addRootNode(T node) {
        this.rootNodes.add(new TreeModelNode<T>(node, null));
    }

    public void addNode(T node, T parent) {
        TreeModelNode<T> parentNode = this.searchTree(parent, this.rootNodes);
        parentNode.addChild(new TreeModelNode<T>(node, parentNode));
    }

    public boolean isChecked(T node) {
        TreeModelNode<T> treeNode = this.searchTree(node);
        return treeNode.isChecked();
    }

    public void nodeStateChanged(T element, boolean checked) {
        TreeModelNode<T> node = this.searchTree(element);
        this.nodeStateChanged(node, checked);
    }

    private void nodeStateChanged(TreeModelNode<T> node, boolean checked) {
        node.setChecked(checked);
        this.checkSubtree(checked, node);
        this.checkParents(node, checked);
    }

    private void checkParents(TreeModelNode<T> node, boolean checked) {
        if (node == null) {
            return;
        }
        TreeModelNode<T> parentElement = node.getParentElement();
        if (parentElement != null) {
            List<TreeModelNode<T>> children = parentElement.getChildren();
            boolean allSiblingsEqual = true;
            for (TreeModelNode<T> child : children) {
                if (child.equals(node)) continue;
                allSiblingsEqual &= checked == child.isChecked();
            }
            boolean checkedAndSiblingsEqual = checked && allSiblingsEqual;
            parentElement.setChecked(checkedAndSiblingsEqual);
            this.checkParents(parentElement, checked && allSiblingsEqual);
        }
    }

    private void checkSubtree(boolean checked, TreeModelNode<T> node) {
        List<TreeModelNode<T>> children = node.getChildren();
        for (TreeModelNode<T> child : children) {
            child.setChecked(checked);
            this.checkSubtree(checked, child);
        }
    }

    private TreeModelNode<T> searchTree(T element) {
        return this.searchTree(element, this.rootNodes);
    }

    private TreeModelNode<T> searchTree(T element, List<TreeModelNode<T>> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        for (TreeModelNode<T> treeModelNode : nodes) {
            if (treeModelNode.getElement().equals(element)) {
                return treeModelNode;
            }
            TreeModelNode<T> targetNode = this.searchTree(element, treeModelNode.getChildren());
            if (targetNode == null) continue;
            return targetNode;
        }
        return null;
    }

    public void setSelectedPaths(List<String> paths, String separator) {
        List<TreeModelNode<T>> nodes = this.rootNodes;
        for (String path : paths) {
            StringTokenizer pathTokenizer = new StringTokenizer(path, separator);
            TreeModelNode<T> node = this.searchTree(pathTokenizer, nodes);
            if (node == null) continue;
            this.nodeStateChanged(node, true);
        }
    }

    private TreeModelNode<T> searchTree(StringTokenizer pathTokenizer, List<TreeModelNode<T>> nodes) {
        if (!pathTokenizer.hasMoreTokens() || nodes.isEmpty()) {
            return null;
        }
        String token = pathTokenizer.nextToken();
        for (TreeModelNode<T> node : nodes) {
            boolean nameMatchesToken = token.equals(this.nameProvidingFunction.getName(node.getElement()));
            if (!nameMatchesToken) continue;
            if (pathTokenizer.hasMoreElements()) {
                return this.searchTree(pathTokenizer, node.getChildren());
            }
            return node;
        }
        return null;
    }

    public List<String> getSelectedPaths(String separator) {
        ArrayList<String> selectedPaths = new ArrayList<String>();
        for (TreeModelNode<T> rootNode : this.rootNodes) {
            String name = this.nameProvidingFunction.getName(rootNode.getElement());
            if (rootNode.isChecked()) {
                selectedPaths.add(name);
                continue;
            }
            List<TreeModelNode<T>> children = rootNode.getChildren();
            this.accumulateSelectedPaths(selectedPaths, name, separator, children);
        }
        return selectedPaths;
    }

    private void accumulateSelectedPaths(ArrayList<String> selectedPaths, String accumulatedPath, String separator, List<TreeModelNode<T>> children) {
        if (children.isEmpty()) {
            return;
        }
        for (TreeModelNode<T> child : children) {
            String pathToChild = accumulatedPath + separator + this.nameProvidingFunction.getName(child.getElement());
            if (child.isChecked()) {
                selectedPaths.add(pathToChild);
                continue;
            }
            this.accumulateSelectedPaths(selectedPaths, pathToChild, separator, child.getChildren());
        }
    }

    public void setAllChecked(boolean checked) {
        for (TreeModelNode<T> rootNode : this.rootNodes) {
            this.nodeStateChanged(rootNode, checked);
        }
    }

    public boolean areAllItemsSelected() {
        return this.areAllItemsSelected(this.rootNodes);
    }

    private boolean areAllItemsSelected(List<TreeModelNode<T>> nodes) {
        for (TreeModelNode<T> node : nodes) {
            if (!node.isChecked()) {
                return false;
            }
            if (this.areAllItemsSelected(node.getChildren())) continue;
            return false;
        }
        return true;
    }

    public List<T> getSelectedElements() {
        ArrayList selectedElements = new ArrayList();
        this.accumulateSelectedElements(selectedElements, this.rootNodes, true);
        return selectedElements;
    }

    public Set<T> getAllUnselectedElements() {
        HashSet unselected = new HashSet();
        ArrayList<TreeModelNode<T>> parentNodes = new ArrayList<TreeModelNode<T>>();
        this.getAllSelectedElements(parentNodes, this.rootNodes, unselected, false);
        return unselected;
    }

    public Set<T> getAllSelectedElements() {
        HashSet selected = new HashSet();
        ArrayList<TreeModelNode<T>> parentNodes = new ArrayList<TreeModelNode<T>>();
        this.getAllSelectedElements(parentNodes, this.rootNodes, selected, true);
        return selected;
    }

    private void getAllSelectedElements(List<TreeModelNode<T>> parentNodes, List<TreeModelNode<T>> nodes, Set<T> selectedNodes, boolean selected) {
        for (TreeModelNode<T> treeModelNode : nodes) {
            if (treeModelNode.hasChildren()) {
                ArrayList<TreeModelNode<T>> newParentNodes = new ArrayList<TreeModelNode<T>>(parentNodes);
                newParentNodes.add(treeModelNode);
                this.getAllSelectedElements(newParentNodes, treeModelNode.getChildren(), selectedNodes, selected);
                continue;
            }
            if (treeModelNode.isChecked() != selected) continue;
            selectedNodes.add(treeModelNode.getElement());
            for (TreeModelNode<T> parentNode : parentNodes) {
                selectedNodes.add(parentNode.getElement());
            }
        }
    }

    private void accumulateSelectedElements(List<T> selectedElements, List<TreeModelNode<T>> nodes, boolean selected) {
        for (TreeModelNode<T> node : nodes) {
            if (node.isChecked() == selected) {
                selectedElements.add(node.getElement());
                continue;
            }
            this.accumulateSelectedElements(selectedElements, node.getChildren(), selected);
        }
    }

    private class TreeModelNode<E> {
        private TreeModelNode<E> parentElement;
        private List<TreeModelNode<E>> children = new ArrayList<TreeModelNode<E>>();
        private E element;
        private boolean checked;

        public TreeModelNode(E element, TreeModelNode<E> parent) {
            this.element = element;
            this.parentElement = parent;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public void addChild(TreeModelNode<E> treeModelNode) {
            this.children.add(treeModelNode);
        }

        public E getElement() {
            return this.element;
        }

        public List<TreeModelNode<E>> getChildren() {
            return this.children;
        }

        public TreeModelNode<E> getParentElement() {
            return this.parentElement;
        }

        public String toString() {
            return "TreeModelNode [element=" + String.valueOf(this.element) + ", checked=" + this.checked + "]";
        }
    }
}

