/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tree;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.search.SearchTextField;
import org.mule.tooling.ui.widgets.tree.ITreeSelectionValidation;
import org.mule.tooling.ui.widgets.tree.NameProvidingFunction;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.TreeModel;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class SelectAllFilteredTree<T>
extends StudioFilteredTree {
    private SelectAllAction selectAllAction;
    private ContainerCheckedTreeViewer checkboxViewer;
    private TreeModel<T> treeModel;
    private NameProvidingFunction<T> nameProvidingFunction;
    private String separator;
    private Optional<ITreeSelectionValidation> validator = Optional.fromNullable(null);

    public SelectAllFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, NameProvidingFunction<T> nameProvidingFunction, String separator) {
        super(parent, treeStyle, filter);
        this.nameProvidingFunction = nameProvidingFunction;
        this.separator = separator;
    }

    protected Composite createFilterControls(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayout((Layout)new WidgetUtils().createNoBorderGridLayout(3, false));
        this.createToolBar(bar);
        Composite createFilterControls = super.createFilterControls(bar);
        createFilterControls.setLayoutData((Object)new GridData(768));
        return bar;
    }

    public void restoreModelFromSelection(T[] objects) {
        this.setAllItemsChecked(false);
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T object = TArray[n2];
            this.treeModel.nodeStateChanged(object, true);
            ++n2;
        }
        this.restoreSelectionFromModel();
        this.selectAllAction.updateStateAndImage();
    }

    @Override
    protected Text doCreateFilterText(Composite parent) {
        return new SearchTextField(parent, "Search");
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob filterJob = super.doCreateRefreshJob();
        filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    SelectAllFilteredTree.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).SelectAllFilteredTree.this.checkboxViewer.getTree().isDisposed()) {
                                return;
                            }
                            (this).SelectAllFilteredTree.this.checkboxViewer.getTree().setRedraw(false);
                            SelectAllFilteredTree.this.restoreSelectionFromModel();
                            (this).SelectAllFilteredTree.this.checkboxViewer.getTree().setRedraw(true);
                        }
                    });
                }
                SelectAllFilteredTree.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).SelectAllFilteredTree.this.selectAllAction.updateStateAndImage();
                    }
                });
            }
        });
        return filterJob;
    }

    private void restoreSelectionFromModel() {
        this.deselectAllInView();
        List<T> selectedElements = this.treeModel.getSelectedElements();
        FixedTreeViewer viewer = this.getViewer();
        for (T element : selectedElements) {
            viewer.expandToLevel(element, 0);
            viewer.setChecked(element, true);
        }
    }

    private void deselectAllInView() {
        this.getViewer().setCheckedElements(new Object[0]);
    }

    private ITreeContentProvider getTreeContentProvider() {
        return (ITreeContentProvider)this.getViewer().getContentProvider();
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        this.checkboxViewer = new FixedTreeViewer(composite, style);
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectAllFilteredTree.this.treeModel.nodeStateChanged(event.getElement(), event.getChecked());
                SelectAllFilteredTree.this.selectAllAction.updateStateAndImage();
            }
        });
        return this.checkboxViewer;
    }

    public FixedTreeViewer getViewer() {
        return (FixedTreeViewer)super.getViewer();
    }

    private void createToolBar(Composite parent) {
        ToolBar ts = new ToolBar(parent, 0);
        ToolBarManager manager = new ToolBarManager(ts);
        this.selectAllAction = new SelectAllAction();
        manager.add((IAction)this.selectAllAction);
        manager.update(true);
        this.selectAllAction.setEnabled(false);
    }

    protected void onUnselectAllPressed() {
        this.setAllItemsChecked(false);
    }

    protected void onSelectAllPressed() {
        this.setAllItemsChecked(true);
    }

    public void setAllItemsChecked(boolean checked) {
        this.treeModel.setAllChecked(checked);
        this.restoreSelectionFromModel();
        this.getValidatorAndValidate();
    }

    public Set<T> getAllUnselectedElements() {
        return this.treeModel.getAllUnselectedElements();
    }

    private void getValidatorAndValidate() {
        if (this.validator.isPresent()) {
            ((ITreeSelectionValidation)this.validator.get()).validateSelection();
        }
    }

    private boolean areAllItemsSelected() {
        return this.treeModel != null && this.treeModel.areAllItemsSelected();
    }

    public void setInput(Object inputData) {
        this.checkboxViewer.setCheckedElements(new Object[0]);
        this.getViewer().setInput(inputData);
        this.selectAllAction.setEnabled(true);
        this.selectAllAction.updateStateAndImage();
        this.createTreeModel(inputData);
    }

    private void createTreeModel(Object inputData) {
        Object[] elements;
        this.treeModel = new TreeModel<T>(this.nameProvidingFunction);
        Object[] objectArray = elements = this.getTreeContentProvider().getElements(inputData);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeModel.addRootNode(element);
            this.fillTreeModel(this.getTreeContentProvider().getChildren(element), element);
            ++n2;
        }
    }

    private void fillTreeModel(T[] elements, T parent) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.treeModel.addNode(element, parent);
            this.fillTreeModel(this.getTreeContentProvider().getChildren(element), element);
            ++n2;
        }
    }

    public void markSelectedPaths(List<String> paths) {
        if (this.treeModel == null) {
            throw new IllegalStateException("Must call setInput to the tree before marking selected paths");
        }
        this.treeModel.setSelectedPaths(paths, this.separator);
        this.restoreSelectionFromModel();
        this.selectAllAction.updateStateAndImage();
    }

    public List<String> getSelectedPaths() {
        return this.treeModel.getSelectedPaths(this.separator);
    }

    public void addSelectionValidation(ITreeSelectionValidation validator) {
        this.validator = Optional.fromNullable((Object)validator);
        this.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectAllFilteredTree.this.getValidatorAndValidate();
            }
        });
        this.getValidatorAndValidate();
    }

    public Object[] getCheckedElements() {
        Object[] visibleChckedElements = this.treeModel.getAllSelectedElements().toArray();
        return visibleChckedElements;
    }

    public void enableSelectAllAction(boolean value) {
        this.selectAllAction.setEnabled(value);
    }

    protected void clearText() {
        super.clearText();
        this.getViewer().collapseAll();
    }

    public final class FixedTreeViewer
    extends ContainerCheckedTreeViewer {
        private FixedTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public Object[] getCheckedElements() {
            Object[] checked = this.superGetCheckedElements();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < checked.length) {
                Item[] children;
                Object curr = checked[i];
                result.add(curr);
                Widget item = this.findItem(curr);
                if (item != null && (children = this.getChildren(item)).length == 1 && children[0].getData() == null) {
                    this.collectChildrenFixed(curr, result);
                }
                ++i;
            }
            return result.toArray();
        }

        private Object[] superGetCheckedElements() {
            ArrayList v = new ArrayList();
            Control tree = this.getControl();
            this._internalCollectChecked(v, (Widget)tree);
            return v.toArray();
        }

        private void _internalCollectChecked(ArrayList<? super Object> result, Widget widget) {
            Item[] items = this.getChildren(widget);
            int i = 0;
            while (i < items.length) {
                Object data;
                Item item = items[i];
                if (item instanceof TreeItem && ((TreeItem)item).getChecked() && (data = item.getData()) != null) {
                    result.add(data);
                }
                this._internalCollectChecked(result, (Widget)item);
                ++i;
            }
        }

        private void collectChildrenFixed(Object element, ArrayList<? super Object> result) {
            Object[] filteredChildren = this.getFilteredChildren(element);
            int i = 0;
            while (i < filteredChildren.length) {
                Object curr = filteredChildren[i];
                result.add(curr);
                if (SelectAllFilteredTree.this.getTreeContentProvider().hasChildren(curr)) {
                    this.collectChildrenFixed(curr, result);
                }
                ++i;
            }
        }
    }

    private final class SelectAllAction
    extends Action {
        private boolean allSelected;

        private SelectAllAction() {
            super("Select All", 0);
            this.allSelected = false;
            this.updateImage();
        }

        protected void updateStateAndImage() {
            this.allSelected = SelectAllFilteredTree.this.areAllItemsSelected();
            this.updateImage();
        }

        protected void updateImage() {
            if (!this.allSelected) {
                this.setImageDescriptor(WidgetsImages.getImageDescriptor("icons/checkboxcleared.gif"));
                this.setToolTipText("Select All");
            } else {
                this.setImageDescriptor(WidgetsImages.getImageDescriptor("icons/checkboxselected.gif"));
                this.setToolTipText("Deselect All");
            }
        }

        public void run() {
            if (!this.allSelected) {
                SelectAllFilteredTree.this.onSelectAllPressed();
                this.allSelected = true;
            } else {
                SelectAllFilteredTree.this.onUnselectAllPressed();
                this.allSelected = false;
            }
            this.updateImage();
        }
    }
}

