/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.toolbar;

import java.util.Optional;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LabelControlContribution
extends ControlContribution {
    private String tooltip;
    private String text;
    private Optional<Color> textColor;
    private CLabel label;

    public LabelControlContribution(String id) {
        this(id, id, Optional.empty());
    }

    public LabelControlContribution(String id, String tooltip, Optional<Color> textColor) {
        super(id);
        this.text = id;
        this.tooltip = tooltip;
        this.textColor = textColor;
    }

    protected Control createControl(Composite parent) {
        this.label = new CLabel(parent, 0);
        this.label.setAlignment(0x1000000);
        this.label.setText(this.text);
        this.label.setToolTipText(this.tooltip);
        if (this.textColor.isPresent()) {
            this.label.setForeground(this.textColor.get());
        }
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, true).applyTo((Control)this.label);
        return this.label;
    }

    public void setText(String text) {
        this.label.setText(text);
    }
}

