/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.text;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.ui.widgets.text.XmlRegion;

public class XmlRegionAnalyzer {
    private int offset;

    public List<XmlRegion> analyzeXml(String xml) {
        this.offset = 0;
        ArrayList<XmlRegion> positions = new ArrayList<XmlRegion>();
        while (this.offset < xml.length()) {
            this.analyzeWhitespaces(xml, positions);
            if (this.offset >= xml.length()) break;
            char c = xml.charAt(this.offset);
            if (c == '<') {
                if (this.analyzeInstruction(xml, positions) || this.analyzeComment(xml, positions) || this.analyzeMarkup(xml, positions) || this.analyzeCData(xml, positions)) continue;
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.UNEXPECTED, this.offset, xml.length()));
                break;
            }
            if (c == '/' && xml.charAt(this.offset + 1) == '>' || c == '>') {
                if (this.analyzeMarkup(xml, positions)) continue;
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.UNEXPECTED, this.offset, xml.length()));
                break;
            }
            if (this.analyzeAttribute(xml, positions) || this.analyzeAttributeValue(xml, positions) || this.analyzeMarkupValue(xml, positions)) continue;
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.UNEXPECTED, this.offset, xml.length()));
            break;
        }
        return positions;
    }

    boolean analyzeInstruction(String xml, List<XmlRegion> positions) {
        boolean result = false;
        int newPos = this.offset;
        if (newPos < xml.length() && xml.charAt(newPos) == '<' && ++newPos < xml.length() && xml.charAt(newPos) == '?') {
            while (++newPos < xml.length() && xml.charAt(newPos) != '>') {
                newPos = xml.indexOf(63, newPos);
            }
            if (xml.charAt(newPos) == '>') {
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.INSTRUCTION, this.offset, newPos + 1));
                this.offset = newPos + 1;
                result = true;
            }
        }
        return result;
    }

    boolean analyzeComment(String xml, List<XmlRegion> positions) {
        boolean result = false;
        int newPos = this.offset;
        if (xml.charAt(newPos) == '<' && ++newPos < xml.length() && xml.charAt(newPos) == '!' && ++newPos < xml.length() && xml.charAt(newPos) == '-' && ++newPos < xml.length() && xml.charAt(newPos) == '-') {
            int seq = 0;
            while (seq != 3 && ++newPos < xml.length()) {
                char c = xml.charAt(newPos);
                int n = seq = c == '-' && seq < 2 || c == '>' && seq == 2 ? seq + 1 : 0;
            }
            if (seq == 3) {
                ++newPos;
            }
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.COMMENT, this.offset, newPos));
            this.offset = newPos;
            result = true;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    boolean analyzeMarkup(String xml, List<XmlRegion> positions) {
        block7: {
            block6: {
                newPos = this.offset;
                result = false;
                if (xml.charAt(newPos) != '<') break block6;
                if (newPos + 1 < xml.length() && xml.charAt(newPos + 1) == '!') {
                    return false;
                }
                c = '!';
                if (true) ** GOTO lbl10
                do {
                    ++newPos;
lbl10:
                    // 2 sources

                    if (newPos >= xml.length()) break;
                    v0 = xml.charAt(newPos);
                    c = v0;
                } while (v0 != '>' && !Character.isWhitespace(c));
                if (c == '>') {
                    ++newPos;
                }
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.MARKUP, this.offset, newPos));
                this.offset = newPos;
                result = true;
                break block7;
            }
            if (xml.charAt(newPos) == '/' && ++newPos < xml.length() && xml.charAt(newPos) == '>') {
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.MARKUP, this.offset, ++newPos));
                this.offset = newPos;
                result = true;
            } else if (xml.charAt(newPos) == '>') {
                positions.add(new XmlRegion(XmlRegion.XmlRegionType.MARKUP, this.offset, ++newPos));
                this.offset = newPos;
                result = true;
            }
        }
        return result;
    }

    boolean analyzeAttribute(String xml, List<XmlRegion> positions) {
        char c;
        int i = positions.size() - 1;
        while (i >= 0) {
            XmlRegion xr = positions.get(i);
            if (xr.getXmlRegionType() != XmlRegion.XmlRegionType.WHITESPACE) {
                if (xr.getXmlRegionType() == XmlRegion.XmlRegionType.ATTRIBUTE_VALUE || xr.getXmlRegionType() == XmlRegion.XmlRegionType.MARKUP && (c = xml.charAt(xr.getEnd() - 1)) != '>') break;
                return false;
            }
            --i;
        }
        boolean result = false;
        int newPos = this.offset;
        while (newPos < xml.length() && (c = xml.charAt(newPos)) != '=' && c != '/' && c != '>' && !Character.isWhitespace(c)) {
            ++newPos;
        }
        if (newPos != this.offset) {
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.ATTRIBUTE, this.offset, newPos));
            this.offset = newPos;
            result = true;
        }
        return result;
    }

    boolean analyzeMarkupValue(String xml, List<XmlRegion> positions) {
        int i = positions.size() - 1;
        while (i >= 0) {
            XmlRegion xr = positions.get(i);
            if (xr.getXmlRegionType() != XmlRegion.XmlRegionType.WHITESPACE) {
                char c;
                if ((xr.getXmlRegionType() == XmlRegion.XmlRegionType.MARKUP || xr.getXmlRegionType() == XmlRegion.XmlRegionType.COMMENT) && (c = xml.charAt(xr.getEnd() - 1)) == '>') break;
                return false;
            }
            --i;
        }
        boolean result = false;
        int newPos = this.offset;
        while (newPos < xml.length() && xml.charAt(newPos) != '<') {
            ++newPos;
        }
        if (this.offset != newPos) {
            XmlRegion xr = positions.get(positions.size() - 1);
            int start = this.offset;
            if (xr.getXmlRegionType() == XmlRegion.XmlRegionType.WHITESPACE) {
                start = xr.getStart();
                positions.remove(xr);
            }
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.MARKUP_VALUE, start, newPos));
            this.offset = newPos;
            result = true;
        }
        return result;
    }

    boolean analyzeAttributeValue(String xml, List<XmlRegion> positions) {
        int i = positions.size() - 1;
        while (i >= 0) {
            XmlRegion xr = positions.get(i);
            if (xr.getXmlRegionType() != XmlRegion.XmlRegionType.WHITESPACE) {
                if (xr.getXmlRegionType() == XmlRegion.XmlRegionType.ATTRIBUTE) break;
                return false;
            }
            --i;
        }
        boolean result = false;
        int newPos = this.offset;
        if (xml.charAt(newPos) == '=') {
            this.analyzeWhitespaces(xml, positions);
            int cpt = 0;
            int previous = 33;
            while (++newPos < xml.length()) {
                char c = xml.charAt(newPos);
                if (previous != 92 && c == '\"') {
                    ++cpt;
                }
                previous = c;
                if (cpt != 2) continue;
                ++newPos;
                break;
            }
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.ATTRIBUTE_VALUE, this.offset, newPos));
            this.offset = newPos;
            result = true;
        }
        return result;
    }

    boolean analyzeCData(String xml, List<XmlRegion> positions) {
        boolean result = false;
        int newPos = this.offset;
        if (xml.charAt(newPos) == '<' && ++newPos < xml.length() && xml.charAt(newPos) == '!' && ++newPos < xml.length() && xml.charAt(newPos) == '[' && ++newPos < xml.length() && xml.charAt(newPos) == 'C' && ++newPos < xml.length() && xml.charAt(newPos) == 'D' && ++newPos < xml.length() && xml.charAt(newPos) == 'A' && ++newPos < xml.length() && xml.charAt(newPos) == 'T' && ++newPos < xml.length() && xml.charAt(newPos) == 'A' && ++newPos < xml.length() && xml.charAt(newPos) == '[') {
            int cpt = 0;
            while (++newPos < xml.length()) {
                char c = xml.charAt(newPos);
                cpt = cpt < 2 && c == ']' || cpt == 2 && c == '>' ? ++cpt : 0;
                if (cpt != 3) continue;
                ++newPos;
                break;
            }
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.CDATA, this.offset, newPos));
            this.offset = newPos;
            result = true;
        }
        return result;
    }

    void analyzeWhitespaces(String xml, List<XmlRegion> positions) {
        int i = this.offset;
        while (i < xml.length() && Character.isWhitespace(xml.charAt(i))) {
            ++i;
        }
        if (i != this.offset) {
            positions.add(new XmlRegion(XmlRegion.XmlRegionType.WHITESPACE, this.offset, i));
            this.offset = i;
        }
    }
}

