/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.text;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.mule.tooling.ui.widgets.text.IHistoryItemAddedListener;

public class History {
    private EvictingQueue<String> history;
    private List<IHistoryItemAddedListener> listeners = new ArrayList<IHistoryItemAddedListener>();

    public History(int maxAmountElements) {
        this.history = EvictingQueue.create((int)maxAmountElements);
    }

    public Collection<String> getHistory() {
        return this.history;
    }

    public String[] getReversedHistory() {
        Object[] reversedHistoryItems = (String[])this.history.stream().toArray(String[]::new);
        ArrayUtils.reverse((Object[])reversedHistoryItems);
        return reversedHistoryItems;
    }

    public void addHistory(String script) {
        if (!this.history.isEmpty() && script.equals(this.getLastItemAdded())) {
            return;
        }
        this.history.add((Object)script);
        for (IHistoryItemAddedListener listener : this.listeners) {
            listener.onItemAdded(script);
        }
    }

    private String getLastItemAdded() {
        return ((String[])this.history.toArray((Object[])new String[0]))[this.history.size() - 1];
    }

    public void addHistoryItemListener(IHistoryItemAddedListener listener) {
        this.listeners.add(listener);
    }

    public void removeHistoryItemListener(IHistoryItemAddedListener listener) {
        this.listeners.remove(listener);
    }

    public void changeSize(int newSize) {
        EvictingQueue newHistory = EvictingQueue.create((int)newSize);
        this.history.forEach(arg_0 -> ((EvictingQueue)newHistory).add(arg_0));
        this.history = newHistory;
    }
}

