/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.table.composite;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.ui.widgets.table.composite.DummyRowHandler;
import org.mule.tooling.ui.widgets.table.composite.EmptyControlsCreator;
import org.mule.tooling.ui.widgets.table.composite.IControlsCreator;
import org.mule.tooling.ui.widgets.table.composite.IRowHandler;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class CompositeTable<RowType, RowData> {
    protected final Composite root;
    protected Composite rowsWrapper;
    protected IControlsCreator titleCreator = new EmptyControlsCreator();
    protected IControlsCreator buttonsCreator = new EmptyControlsCreator();
    protected IRowHandler<RowType, RowData> rowHandler = new DummyRowHandler<RowType, RowData>();
    private EventBus eventBus;
    private EventBusHelper eventHelper = new EventBusHelper();

    public CompositeTable(Composite parent, EventBus eventBus) {
        this.eventBus = eventBus;
        this.root = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.root);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.root);
    }

    public void createControls() {
        this.titleCreator.createControls(this.root, this.eventBus, this.eventHelper);
        this.rowsWrapper = this.createWrapper(this.root);
        this.rowHandler.createEmptyCanvas(this.root);
        Composite buttonsWrapper = this.createWrapper(this.root);
        this.buttonsCreator.createControls(buttonsWrapper, this.eventBus, this.eventHelper);
    }

    private Composite createWrapper(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        return wrapper;
    }

    public void addRow(RowData rowData) {
        this.rowHandler.addRow(this.rowsWrapper, rowData);
        this.root.layout(true, true);
    }

    public void clearRows() {
        Control[] controlArray = this.rowsWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.rowHandler.clearRows(this.rowsWrapper);
        this.rowHandler.createEmptyCanvas(this.root);
        this.root.layout(true, true);
    }

    public void setTitleCreator(IControlsCreator creator) {
        this.titleCreator = creator;
    }

    public void setRowHandler(IRowHandler<RowType, RowData> rowHandler) {
        this.rowHandler = rowHandler;
    }

    public void setButtonsCreator(IControlsCreator buttonsCreator) {
        this.buttonsCreator = buttonsCreator;
    }
}

