/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.table.composite;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.ui.widgets.table.composite.IControlsCreator;
import org.mule.tooling.ui.widgets.table.composite.IRowHandler;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public abstract class BaseRowHandler<RowType extends IControlsCreator, RowData>
implements IRowHandler<RowType, RowData> {
    private static final String EMPTY_MESSAGE = "There are no rows";
    private final List<RowType> rows = Lists.newArrayList();
    private Composite emptyCanvas;
    private final EventBus eventBus;
    private final EventBusHelper eventHelper;

    public BaseRowHandler(EventBus eventBus, EventBusHelper eventHelper) {
        this.eventBus = eventBus;
        this.eventHelper = eventHelper;
    }

    @Override
    public List<RowType> getRows() {
        return this.rows;
    }

    @Override
    public void disposeEmptyCanvas() {
        if (this.emptyCanvas != null && !this.emptyCanvas.isDisposed()) {
            this.emptyCanvas.dispose();
        }
    }

    protected String emptyCanvasMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public final void createEmptyCanvas(Composite parent) {
        this.emptyCanvas = new Group(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(5, 5, 5, 5).applyTo(this.emptyCanvas);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.emptyCanvas);
        Label emptyCanvasLabel = new Label(this.emptyCanvas, 0x1000000);
        emptyCanvasLabel.setText(this.emptyCanvasMessage());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)emptyCanvasLabel);
    }

    @Override
    public void addRow(Composite rowsWrapper, RowData data) {
        if (this.rows.isEmpty()) {
            this.disposeEmptyCanvas();
        }
        IControlsCreator row = (IControlsCreator)this.createRow(data);
        row.createControls(rowsWrapper, this.eventBus, this.eventHelper);
        this.rows.add(row);
    }

    @Override
    public void addRows(Composite rowsWrapper, List<RowData> newRows) {
        if (newRows == null || newRows.isEmpty()) {
            return;
        }
        if (this.rows.isEmpty()) {
            this.disposeEmptyCanvas();
        }
        for (RowData routeInfo : newRows) {
            IControlsCreator row = (IControlsCreator)this.createRow(routeInfo);
            row.createControls(rowsWrapper, this.eventBus, this.eventHelper);
            this.rows.add(row);
        }
    }

    @Override
    public void clearRows(Composite rowsWrapper) {
        Control[] controlArray = rowsWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.rows.clear();
    }

    public Composite getEmptyCanvas() {
        return this.emptyCanvas;
    }

    public void setEmptyCanvas(Composite emptyCanvasComposite) {
        this.emptyCanvas = emptyCanvasComposite;
    }
}

