/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.action.IModificationListener;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MapTableComposite
extends Composite {
    public static final String VALUE_PROPERTY = "Value";
    public static final String KEY_PROPERTY = "Key";
    private PairViewerComparator comparator;
    private String[] columns;
    private Action delete;
    private Action deleteAll;
    private Action add;
    private List<Pair> data;
    private TableViewer tableViewer;
    private List<IModificationListener> listeners;
    private ToolBarManager toolBarManager;
    private String defaultInputKey;
    private String defaultInputValue;

    public MapTableComposite(Composite parent, int style, String ... columns) {
        super(parent, style);
        this.columns = columns;
        this.data = new ArrayList<Pair>();
        WidgetUtils widgetUtils = new WidgetUtils();
        this.setLayout((Layout)widgetUtils.createNoBorderGridLayout(1, true));
        this.createControl(this, widgetUtils);
        this.listeners = new ArrayList<IModificationListener>();
    }

    public void addModificationListener(IModificationListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyModified(Object oldValue, Object value, ModificationType type) {
        for (IModificationListener listener : this.listeners) {
            listener.onModified(oldValue, value, this.tableViewer, type);
        }
    }

    protected void createControl(Composite parent, WidgetUtils widgetUtils) {
        ToolBar toolBar = this.createControlMenu(parent);
        toolBar.setLayoutData((Object)new GridData(768));
        this.setTableViewer(widgetUtils.createTableViewer(parent, this.columns));
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tableViewer));
        ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                EventObject source;
                if (event.eventType == 2 && (source = event.sourceEvent) instanceof MouseEvent && ((MouseEvent)source).button == 3) {
                    return false;
                }
                return super.isEditorActivationEvent(event) || event.eventType == 1 && event.keyCode == 13;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationSupport, (int)58);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setColumnProperties(new String[]{KEY_PROPERTY, VALUE_PROPERTY});
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable(), 0), new TextCellEditor((Composite)this.tableViewer.getTable(), 0)});
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PairLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new PairCellModifier(this));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MapTableComposite.this.delete.setEnabled(!event.getSelection().isEmpty());
                MapTableComposite.this.deleteAll.setEnabled(!MapTableComposite.this.getInputData().isEmpty());
            }
        });
        this.tableViewer.setInput(this.data);
        this.comparator = new PairViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        TableColumn[] tableColumns = this.tableViewer.getTable().getColumns();
        int index = 0;
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, index));
            ++index;
            ++n2;
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapTableComposite.this.comparator.setColumn(index);
                int dir = MapTableComposite.this.comparator.getDirection();
                MapTableComposite.this.tableViewer.getTable().setSortDirection(dir);
                MapTableComposite.this.tableViewer.getTable().setSortColumn(column);
                MapTableComposite.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setCustomCellModifier(ICellModifier customModifier) {
        this.tableViewer.setCellModifier(customModifier);
    }

    public void setInputData(Map<String, String> data) {
        this.clear();
        Set<Map.Entry<String, String>> entrySet = data.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.data.add(new Pair(entry.getKey(), entry.getValue()));
        }
        if (this.deleteAll != null) {
            this.deleteAll.setEnabled(!data.isEmpty());
        }
        this.refreshTableViewer();
    }

    public void refreshTableViewer() {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public Map<String, String> getInputData() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Pair pair : this.data) {
            result.put(pair.getKey(), pair.getValue());
        }
        return result;
    }

    private ToolBar createControlMenu(Composite parent) {
        ToolBar ts = new ToolBar(parent, 0);
        this.toolBarManager = new ToolBarManager(ts);
        this.delete = new Action("Delete Selected", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                if (!MapTableComposite.this.tableViewer.getSelection().isEmpty()) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)MapTableComposite.this.tableViewer.getSelection();
                    Object[] elements = structuredSelection.toArray();
                    MapTableComposite.this.data.removeAll(Arrays.asList(elements));
                    MapTableComposite.this.tableViewer.remove(elements);
                    MapTableComposite.this.notifyModified(elements, null, ModificationType.DELETE);
                    MapTableComposite.this.refreshTableViewer();
                }
            }
        };
        this.delete.setEnabled(false);
        this.add = new Action("Add Variable", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD")){

            public void run() {
                Pair element = new Pair(MapTableComposite.this.getNexAvailableKey(MapTableComposite.this.getDefaultNewInputKey()), MapTableComposite.this.getDefaultNewInputValue());
                MapTableComposite.this.tableViewer.add((Object)element);
                MapTableComposite.this.data.add(element);
                MapTableComposite.this.notifyModified(null, element, ModificationType.ADD);
                MapTableComposite.this.tableViewer.editElement((Object)element, 0);
            }
        };
        this.deleteAll = new Action(){

            public void run() {
                MapTableComposite.this.deleteAll();
            }
        };
        this.deleteAll.setEnabled(false);
        this.deleteAll.setText("Delete all");
        this.deleteAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
        this.deleteAll.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL_DISABLED"));
        this.toolBarManager.add((IAction)this.add);
        this.toolBarManager.add((IAction)this.delete);
        this.toolBarManager.add((IAction)this.deleteAll);
        this.toolBarManager.update(true);
        return ts;
    }

    protected void deleteAll() {
        ArrayList elements = new ArrayList();
        elements.addAll((List)this.tableViewer.getInput());
        this.data.removeAll(elements);
        this.tableViewer.remove(elements);
        this.notifyModified(elements, null, ModificationType.DELETE);
        this.refreshTableViewer();
    }

    public void addCustomActions(Action ... customActions) {
        Action[] actionArray = customActions;
        int n = customActions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.toolBarManager.add((IAction)action);
            ++n2;
        }
        this.toolBarManager.update(true);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isRepeated(String key) {
        return this.getInputData().containsKey(key);
    }

    public String getDefaultNewInputKey() {
        if (this.defaultInputKey != null) {
            return this.defaultInputKey;
        }
        return "";
    }

    public String getDefaultNewInputValue() {
        if (this.defaultInputValue != null) {
            return this.defaultInputValue;
        }
        return "";
    }

    public void setDefaultInputKey(String defaultInputKey) {
        this.defaultInputKey = defaultInputKey;
    }

    public void setDefaultInputValue(String defaultInputValue) {
        this.defaultInputValue = defaultInputValue;
    }

    private String getNexAvailableKey(String defaultNewInputKey) {
        String key = this.getDefaultNewInputKey();
        String keyPattern = "\"Key-%s\"";
        Map<String, String> data = this.getInputData();
        int suffix = 1;
        while (data.containsKey(key)) {
            key = String.format(keyPattern, suffix);
            ++suffix;
        }
        return key;
    }

    public static enum ModificationType {
        DELETE,
        EDIT,
        ADD;

    }

    public static class Pair {
        private String key;
        private String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class PairCellModifier
    implements ICellModifier {
        private MapTableComposite mapTableComposite;

        public PairCellModifier(MapTableComposite mapTableComposite) {
            this.mapTableComposite = mapTableComposite;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof Pair) {
                if (property.equals(MapTableComposite.KEY_PROPERTY)) {
                    return ((Pair)element).getKey();
                }
                return ((Pair)element).getValue();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            Object data = item.getData();
            if (data instanceof Pair) {
                Pair pair = (Pair)data;
                Pair oldPair = new Pair(pair.getKey(), pair.getValue());
                if (property.equals(MapTableComposite.KEY_PROPERTY)) {
                    this.onSetKey(pair, value);
                } else {
                    this.onSetValue(pair, value);
                }
                this.mapTableComposite.getTableViewer().update((Object)pair, new String[]{property});
                this.mapTableComposite.notifyModified(oldPair, pair, ModificationType.EDIT);
                this.mapTableComposite.getTableViewer().refresh();
            }
        }

        protected void onSetKey(Object data, Object value) {
            ((Pair)data).setKey(String.valueOf(value));
        }

        protected void onSetValue(Object data, Object value) {
            ((Pair)data).setValue(String.valueOf(value));
        }
    }

    private static class PairLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PairLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Pair) {
                switch (columnIndex) {
                    case 0: {
                        return ((Pair)element).getKey();
                    }
                }
                return ((Pair)element).getValue();
            }
            return null;
        }
    }

    public class PairViewerComparator
    extends ViewerComparator {
        private int columnIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.columnIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.columnIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Pair p1 = (Pair)e1;
            Pair p2 = (Pair)e2;
            int rc = 0;
            switch (this.columnIndex) {
                case 0: {
                    rc = p1.getKey().toLowerCase().compareTo(p2.getKey().toLowerCase());
                    break;
                }
                case 1: {
                    rc = p1.getValue().toLowerCase().compareTo(p2.getValue().toLowerCase());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

