/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mule.tooling.ui.widgets.IItem;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.MessageLogger;
import org.mule.tooling.ui.widgets.tab.IItemContainer;
import org.mule.tooling.ui.widgets.tab.ITabItem;
import org.mule.tooling.ui.widgets.tab.TabbedPropertyList;
import org.mule.tooling.ui.widgets.tab.TabbedPropertySheetWidgetFactory;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class VerticalPropertiesTabFolder
extends Composite
implements IItemContainer,
DisposeListener {
    private TabbedPropertyList tabMenu;
    private Composite editor;
    private List<Control> elements;
    private List<VerticalTabItem> items;
    private MessageLogger messageLogger;
    private StackLayout editorLayout;
    private Color borderColor = this.getDisplay().getSystemColor(2);
    private int styleableBorderWidth = 1;

    public VerticalPropertiesTabFolder(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new WidgetUtils().createNoBorderGridLayout(2, false);
        this.elements = new ArrayList<Control>();
        this.items = new ArrayList<VerticalTabItem>();
        this.setLayout((Layout)layout);
        this.createControl();
        this.addDisposeListener(this);
    }

    private void createControl() {
        this.tabMenu = new TabbedPropertyList(this, new TabbedPropertySheetWidgetFactory());
        this.tabMenu.setLayoutData(new GridData(1040));
        this.tabMenu.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                VerticalPropertiesTabFolder.this.setSelection(VerticalPropertiesTabFolder.this.tabMenu.getSelectionIndex());
            }
        });
        final Composite container = new Composite((Composite)this, 4);
        container.setLayoutData((Object)new GridData(1808));
        final GridLayout createNoBorderGridLayout = new WidgetUtils().createNoBorderGridLayout(1, false);
        createNoBorderGridLayout.marginLeft = this.getStyleableBorderWidth();
        container.setLayout((Layout)createNoBorderGridLayout);
        container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(VerticalPropertiesTabFolder.this.getBorderColor());
                e.gc.setLineWidth(VerticalPropertiesTabFolder.this.getStyleableBorderWidth());
                createNoBorderGridLayout.marginLeft = VerticalPropertiesTabFolder.this.getStyleableBorderWidth();
                e.gc.drawLine(0, 0, 0, container.getBounds().height);
            }
        });
        this.messageLogger = new MessageLogger(container, 0);
        this.messageLogger.setLayoutData(new GridData(768));
        this.editor = new Composite(container, 0);
        this.editorLayout = new StackLayout();
        this.editor.setLayout((Layout)this.editorLayout);
        this.editor.setLayoutData((Object)new GridData(1808));
        this.editor.setBackground(Display.getCurrent().getSystemColor(1));
        this.editor.setBackgroundMode(2);
    }

    public IMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    @Override
    public IItem[] getItems() {
        TabbedPropertyList.ListElement[] elements = this.tabMenu.getElements();
        IItem[] result = new IItem[elements.length];
        int i = 0;
        TabbedPropertyList.ListElement[] listElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TabbedPropertyList.ListElement listElement = listElementArray[n2];
            result[i] = (IItem)((Object)listElement.getTabItem());
            ++i;
            ++n2;
        }
        return result;
    }

    @Override
    public Composite getContentContainer() {
        return this.editor;
    }

    @Override
    public IItem createNewItem(int style, int index) {
        VerticalTabItem verticalTabItem = new VerticalTabItem();
        this.items.add(index, verticalTabItem);
        this.tabMenu.addElement(index, verticalTabItem);
        this.tabMenu.redraw();
        return verticalTabItem;
    }

    public void removeItem(int index) {
        this.items.get(index).removeListener();
        this.items.remove(index);
        this.elements.remove(index);
        this.tabMenu.removeElement(index);
    }

    @Override
    public void setSelection(int i) {
        this.editorLayout.topControl = this.elements.get(i);
        this.tabMenu.select(i);
        this.editor.layout();
    }

    @Override
    public IItem createNewItem(int style) {
        return this.createNewItem(style, this.tabMenu.getElements().length);
    }

    public void widgetDisposed(DisposeEvent e) {
        for (VerticalTabItem item : this.items) {
            item.removeListener();
        }
        this.items.clear();
        this.elements.clear();
        this.removeDisposeListener(this);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getStyleableBorderWidth() {
        return this.styleableBorderWidth;
    }

    public void setStyleableBorderWidth(int styleableBorderWidth) {
        this.styleableBorderWidth = styleableBorderWidth;
    }

    @Override
    public void refreshItems() {
        this.tabMenu.refreshItems();
    }

    private class VerticalTabItem
    implements IItem,
    ITabItem,
    DisposeListener {
        private Image image;
        private Control control;
        private String text = "";

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public boolean isIndented() {
            return false;
        }

        @Override
        public Control getControl() {
            return this.control;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void dispose() {
            this.control.dispose();
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        protected int getIndex() {
            return VerticalPropertiesTabFolder.this.items.indexOf(this);
        }

        @Override
        public void setControl(Control control) {
            if (this.control != null) {
                this.removeListener();
            }
            this.control = control;
            if (this.control != null) {
                this.control.addDisposeListener((DisposeListener)this);
            }
            VerticalPropertiesTabFolder.this.elements.add(this.getIndex(), control);
        }

        protected void removeListener() {
            this.control.removeDisposeListener((DisposeListener)this);
        }

        @Override
        public void setToolTipText(String toolTip) {
            VerticalPropertiesTabFolder.this.tabMenu.getElementAt(this.getIndex()).setToolTipText(toolTip);
        }

        public void widgetDisposed(DisposeEvent e) {
            VerticalPropertiesTabFolder.this.removeItem(this.getIndex());
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

