/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.FormColors;
import org.mule.tooling.ui.widgets.tab.ITabItem;
import org.mule.tooling.ui.widgets.tab.TabbedPropertySheetWidgetFactory;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.OsDetect;

public class TabbedPropertyList
extends Composite {
    private static final int VERTICAL_SPACING = 10;
    protected static final int LEFT_TABS_TRIM = 0;
    protected static final int NONE = -1;
    protected int verticalIndent = 13;
    private boolean focus = false;
    private final GC gc;
    private final List<ListElement> elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private TopNavigationElement topNavigationElement;
    private BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color selectedWidgetForeground;
    private Color widgetForeground;
    private Color widgetBackground;
    private Color widgetNormalShadow;
    private Color widgetDarkShadow;
    private Color listBackground;
    private Color hoverGradientStart;
    private Color hoverGradientEnd;
    private Color defaultGradientStart;
    private Color defaultGradientEnd;
    private Color indentedDefaultBackground;
    private Color indentedHoverBackground;
    private Color navigationElementShadowStroke;
    private Color bottomNavigationElementShadowStroke1;
    private Color bottomNavigationElementShadowStroke2;
    private Color hoverWidgetForeground;
    private TabbedPropertySheetWidgetFactory factory;
    private boolean sequentialMode = false;
    private int maxSelectedIndex = 0;
    private boolean customSize = false;
    private boolean selectedLineRight = false;
    private int customWidth = 0;
    private int topElementHeight = 20;
    private int tabItemHeight = 0;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
    boolean insideLayout;

    public TabbedPropertyList(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super(parent, 524288);
        this.gc = new GC((Drawable)this);
        this.resourceManager.disposeExec(this::disposeResources);
        this.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.factory = factory;
        this.elements = new ArrayList<ListElement>();
        this.removeAll();
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.initColours();
        this.initAccessible();
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedPropertyList.this.focus = true;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements.get(i).redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedPropertyList.this.focus = false;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements.get(i).redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = TabbedPropertyList.this.elements.size() - 1;
                    int nCurrent = TabbedPropertyList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    TabbedPropertyList.this.select(nCurrent);
                    TabbedPropertyList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    public void selectAllElements() {
        this.setAllSelected(true);
    }

    public void unSelectAllElements() {
        this.setAllSelected(false);
    }

    private void setAllSelected(boolean selected) {
        for (ListElement element : this.elements) {
            element.setSelected(selected);
        }
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public ListElement getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public ListElement[] getElements() {
        return this.elements.toArray(new ListElement[this.elements.size()]);
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        int i = 0;
        while (i < this.elements.size()) {
            this.elements.get(i).dispose();
            ++i;
        }
        this.elements.clear();
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void refreshItems() {
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
        this.refreshWidestLabel();
        this.computeTabsThatFitInComposite();
        this.computeTopAndBottomTab();
        this.layoutTabs();
        this.redraw();
    }

    public void setElements(ITabItem[] children) {
        if (!this.elements.isEmpty()) {
            this.removeAll();
        }
        if (children.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.length) {
                ITabItem item = children[i];
                this.addElement(i, item);
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public ListElement addElement(ITabItem item) {
        return this.addElement(this.elements.size(), item);
    }

    public ListElement addElement(int i, ITabItem item) {
        ListElement element = new ListElement(this, item);
        this.elements.add(i, element);
        element.setVisible(false);
        if (item.getId() != null) {
            ThemeUtils.setCssClass((Object)element, item.getId().replace('.', '-'));
        }
        if (i != this.widestLabelIndex) {
            String label = item.getText();
            int width = this.getTextDimension((String)label).x + 10;
            if (item.isIndented()) {
                width += this.verticalIndent;
            }
            if (this.widestLabelIndex < 0 || width > this.getTextDimension((String)this.elements.get((int)this.widestLabelIndex).getTabItem().getText()).x) {
                this.widestLabelIndex = i;
            }
        }
        if (this.selectedElementIndex == i) {
            this.selectedElementIndex = i + 1;
            this.doSelect(i);
        }
        return element;
    }

    public void removeElement(int index) {
        this.elements.remove(index).dispose();
        if (this.selectedElementIndex == index) {
            this.selectedElementIndex = -1;
            this.doSelect(0);
        }
        this.refreshWidestLabel();
        this.redraw();
        this.layoutTabs();
    }

    protected void refreshWidestLabel() {
        this.widestLabelIndex = -1;
        int i = 0;
        for (ListElement element : this.elements) {
            String label = element.getTabItem().getText();
            int width = this.getTextDimension((String)label).x + 10;
            if (this.widestLabelIndex < 0 || width > this.getTextDimension((String)this.elements.get((int)this.widestLabelIndex).getTabItem().getText()).x) {
                this.widestLabelIndex = i;
            }
            ++i;
        }
    }

    public void select(int index) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        this.doSelect(index);
    }

    protected void doSelect(int index) {
        if (index >= 0 && index < this.elements.size()) {
            int lastSelected = this.getSelectionIndex();
            this.elements.get(index).setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements.get(lastSelected).setSelected(false);
                if (this.getSelectionIndex() != this.elements.size() - 1) {
                    this.elements.get(this.getSelectionIndex() + 1).setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements.get(this.getSelectionIndex()).setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.getElementIndex();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String properties_not_available = "not available";
            result.x = this.getTextDimension((String)properties_not_available).x + this.verticalIndent;
        } else if (this.isCustomSize()) {
            result.x = this.getCustomWidth();
        } else {
            ITabItem widestTab = this.elements.get(this.widestLabelIndex).getTabItem();
            int width = this.getTextDimension((String)widestTab.getText()).x + this.verticalIndent;
            if (widestTab.getImage() != null) {
                width = width + 16 + 4;
            }
            if (widestTab.isIndented()) {
                width += 10;
            }
            result.x = width + 20;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        if (text == null) {
            return new Point(0, 0);
        }
        Point point = this.gc.textExtent(text);
        ++point.x;
        return point;
    }

    private void initColours() {
        this.setListBackground(Display.getCurrent().getSystemColor(25));
        this.setWidgetBackground(Display.getCurrent().getSystemColor(22));
        this.setWidgetDarkShadow(Display.getCurrent().getSystemColor(17));
        this.setWidgetForeground(Display.getCurrent().getSystemColor(21));
        this.setWidgetNormalShadow(Display.getCurrent().getSystemColor(18));
        RGB white = Display.getCurrent().getSystemColor(1).getRGB();
        RGB black = Display.getCurrent().getSystemColor(2).getRGB();
        this.setHoverWidgetForeground(Display.getCurrent().getSystemColor(21));
        this.setSelectedWidgetForeground(Display.getCurrent().getSystemColor(21));
        Color gradientColor = this.resourceManager.createColor(new RGB(225, 225, 225));
        this.setDefaultGradientStart(gradientColor);
        this.setDefaultGradientEnd(gradientColor);
        this.setNavigationElementShadowStroke(this.factory.getColors().createColor("TabbedPropertyList.shadowStroke", FormColors.blend((RGB)white, (RGB)this.getWidgetNormalShadow().getRGB(), (int)55)));
        this.setBottomNavigationElementShadowStroke1(this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke1", FormColors.blend((RGB)black, (RGB)this.getWidgetBackground().getRGB(), (int)10)));
        this.setBottomNavigationElementShadowStroke2(this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke2", FormColors.blend((RGB)black, (RGB)this.getWidgetBackground().getRGB(), (int)5)));
        this.setHoverGradientStart(this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientStart", FormColors.blend((RGB)white, (RGB)this.getWidgetBackground().getRGB(), (int)20)));
        this.setHoverGradientEnd(this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientEnd", FormColors.blend((RGB)this.getWidgetNormalShadow().getRGB(), (RGB)this.getWidgetBackground().getRGB(), (int)10)));
        this.setIndentedDefaultBackground(this.factory.getColors().createColor("TabbedPropertyList.indentedDefaultBackground", FormColors.blend((RGB)white, (RGB)this.getWidgetBackground().getRGB(), (int)10)));
        this.setIndentedHoverBackground(this.factory.getColors().createColor("TabbedPropertyList.indentedHoverBackground", FormColors.blend((RGB)white, (RGB)this.getWidgetBackground().getRGB(), (int)75)));
        this.factory.getColors().createColor("TabbedPropertyList.tabBlack", new RGB(15, 15, 15));
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + this.verticalIndent;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.elements.size() > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.size() - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.size() > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    public void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.size() == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.size()) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.size() - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.size()) {
            this.bottomVisibleIndex = this.elements.size() - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    protected void layoutTabs() {
        if (this.insideLayout) {
            return;
        }
        this.insideLayout = true;
        try {
            if (this.tabsThatFitInComposite == -1 || this.elements.size() == 0) {
                formData = new FormData();
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.top = new FormAttachment(0, 0);
                formData.height = this.getTabHeight();
                this.topNavigationElement.setLayoutData(formData);
                formData = new FormData();
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
                formData.bottom = new FormAttachment(100, 0);
                this.bottomNavigationElement.setLayoutData(formData);
            } else {
                formData = new FormData();
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.top = new FormAttachment(0, 0);
                formData.height = this.getTopElementHeight();
                this.topNavigationElement.setLayoutData(formData);
                TopNavigationElement nextElement = this.topNavigationElement;
                int i = 0;
                while (i < this.elements.size()) {
                    if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                        this.elements.get(i).setLayoutData(null);
                        this.elements.get(i).setVisible(false);
                    } else {
                        formData = new FormData();
                        formData.height = this.getTabHeight();
                        formData.left = new FormAttachment(0, 0);
                        formData.right = new FormAttachment(100);
                        formData.top = new FormAttachment((Control)nextElement, 0);
                        nextElement = this.elements.get(i);
                        this.elements.get(i).setLayoutData(formData);
                        this.elements.get(i).setVisible(true);
                    }
                    ++i;
                }
                formData = new FormData();
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.top = new FormAttachment((Control)nextElement, 0);
                formData.bottom = new FormAttachment(100, 0);
                formData.height = 10;
                this.bottomNavigationElement.setLayoutData(formData);
            }
            Composite grandparent = this.getParent().getParent();
            grandparent.layout(true);
            this.layout(true);
        }
        finally {
            this.insideLayout = false;
        }
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements.get(TabbedPropertyList.this.getSelectionIndex()).getTabItem().getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements.get(TabbedPropertyList.this.getSelectionIndex()).getTabItem().getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TabbedPropertyList.this.toControl(new Point(e.x, e.y));
                e.childID = TabbedPropertyList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    Rectangle location = TabbedPropertyList.this.elements.get(TabbedPropertyList.this.getSelectionIndex()).getBounds();
                    Point pt = TabbedPropertyList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    public void setEnabled(int pageIndex, boolean ep) {
        this.elements.get(pageIndex).setEnabled(ep);
        this.redraw();
        this.elements.get(pageIndex).redraw();
    }

    public boolean hasElements() {
        return this.elements != null && this.elements.size() > 0;
    }

    public boolean isSequentialMode() {
        return this.sequentialMode;
    }

    public void setSequentialMode(boolean sequentialMode) {
        this.sequentialMode = sequentialMode;
    }

    public Color getWidgetForeground() {
        return this.widgetForeground;
    }

    public void setWidgetForeground(Color widgetForeground) {
        this.widgetForeground = widgetForeground;
    }

    public Color getWidgetBackground() {
        return this.widgetBackground;
    }

    public void setWidgetBackground(Color widgetBackground) {
        this.widgetBackground = widgetBackground;
    }

    public Color getWidgetNormalShadow() {
        return this.widgetNormalShadow;
    }

    public void setWidgetNormalShadow(Color widgetNormalShadow) {
        this.widgetNormalShadow = widgetNormalShadow;
    }

    public Color getWidgetDarkShadow() {
        return this.widgetDarkShadow;
    }

    public void setWidgetDarkShadow(Color widgetDarkShadow) {
        this.widgetDarkShadow = widgetDarkShadow;
    }

    public Color getListBackground() {
        return this.listBackground;
    }

    public void setListBackground(Color listBackground) {
        this.listBackground = listBackground;
    }

    public Color getHoverGradientStart() {
        return this.hoverGradientStart;
    }

    public void setHoverGradientStart(Color hoverGradientStart) {
        this.hoverGradientStart = hoverGradientStart;
    }

    public Color getHoverGradientEnd() {
        return this.hoverGradientEnd;
    }

    public void setHoverGradientEnd(Color hoverGradientEnd) {
        this.hoverGradientEnd = hoverGradientEnd;
    }

    public Color getDefaultGradientStart() {
        return this.defaultGradientStart;
    }

    public void setDefaultGradientStart(Color defaultGradientStart) {
        this.defaultGradientStart = defaultGradientStart;
    }

    public Color getDefaultGradientEnd() {
        return this.defaultGradientEnd;
    }

    public void setDefaultGradientEnd(Color defaultGradientEnd) {
        this.defaultGradientEnd = defaultGradientEnd;
    }

    public Color getIndentedDefaultBackground() {
        return this.indentedDefaultBackground;
    }

    public void setIndentedDefaultBackground(Color indentedDefaultBackground) {
        this.indentedDefaultBackground = indentedDefaultBackground;
    }

    public Color getIndentedHoverBackground() {
        return this.indentedHoverBackground;
    }

    public void setIndentedHoverBackground(Color indentedHoverBackground) {
        this.indentedHoverBackground = indentedHoverBackground;
    }

    public Color getNavigationElementShadowStroke() {
        return this.navigationElementShadowStroke;
    }

    public void setNavigationElementShadowStroke(Color navigationElementShadowStroke) {
        this.navigationElementShadowStroke = navigationElementShadowStroke;
    }

    public Color getBottomNavigationElementShadowStroke1() {
        return this.bottomNavigationElementShadowStroke1;
    }

    public void setBottomNavigationElementShadowStroke1(Color bottomNavigationElementShadowStroke1) {
        this.bottomNavigationElementShadowStroke1 = bottomNavigationElementShadowStroke1;
    }

    public Color getBottomNavigationElementShadowStroke2() {
        return this.bottomNavigationElementShadowStroke2;
    }

    public void setBottomNavigationElementShadowStroke2(Color bottomNavigationElementShadowStroke2) {
        this.bottomNavigationElementShadowStroke2 = bottomNavigationElementShadowStroke2;
    }

    public Color getHoverWidgetForeground() {
        return this.hoverWidgetForeground;
    }

    public void setHoverWidgetForeground(Color hoverWidgetForeground) {
        this.hoverWidgetForeground = hoverWidgetForeground;
    }

    public Color getSelectedWidgetForeground() {
        return this.selectedWidgetForeground;
    }

    public void setSelectedWidgetForeground(Color selectedWidgetForeground) {
        this.selectedWidgetForeground = selectedWidgetForeground;
    }

    public boolean isCustomSize() {
        return this.customSize;
    }

    public void setCustomSize(boolean customSize) {
        this.customSize = customSize;
    }

    public int getCustomWidth() {
        return this.customWidth;
    }

    public void setCustomWidth(int customWidth) {
        this.customWidth = customWidth;
    }

    public int getTopElementHeight() {
        return this.topElementHeight;
    }

    public void setTopElementHeight(int topElementHeight) {
        this.topElementHeight = topElementHeight;
    }

    public boolean isSelectedLineRight() {
        return this.selectedLineRight;
    }

    public void setSelectedLineRight(boolean selectedLineRight) {
        this.selectedLineRight = selectedLineRight;
    }

    public int getTabItemHeight() {
        return this.tabItemHeight;
    }

    public void setTabItemHeight(int tabItemHeight) {
        this.tabItemHeight = tabItemHeight;
    }

    public boolean isGCDisposed() {
        return this.gc.isDisposed();
    }

    private void disposeResources() {
        if (!OsDetect.isMac()) {
            this.gc.dispose();
        }
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    BottomNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.this.isDownScrollRequired()) {
                        ++((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.topVisibleIndex;
                        if (((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.bottomVisibleIndex != ((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.elements.size() - 1) {
                            ++((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.bottomVisibleIndex;
                        }
                        TabbedPropertyList.this.layoutTabs();
                        ((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.topNavigationElement.redraw();
                        ((BottomNavigationElement)BottomNavigationElement.this).TabbedPropertyList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.getWidgetBackground());
            e.gc.setForeground(TabbedPropertyList.this.getWidgetForeground());
            Rectangle bounds = this.getBounds();
            if (!TabbedPropertyList.this.elements.isEmpty()) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.getWidgetNormalShadow());
                e.gc.setForeground(TabbedPropertyList.this.getBottomNavigationElementShadowStroke1());
                e.gc.setForeground(TabbedPropertyList.this.getBottomNavigationElementShadowStroke2());
            } else {
                e.gc.setBackground(TabbedPropertyList.this.getListBackground());
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (TabbedPropertyList.this.isDownScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.getWidgetDarkShadow());
                int middle = bounds.width / 2;
                int bottom = bounds.height - 3;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
                e.gc.setForeground(TabbedPropertyList.this.getListBackground());
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.setForeground(TabbedPropertyList.this.getWidgetNormalShadow());
                e.gc.drawLine(0, bottom - 7, bounds.width - 2, bottom - 7);
                e.gc.setForeground(TabbedPropertyList.this.getNavigationElementShadowStroke());
                e.gc.drawLine(0, bottom + 2, bounds.width - 2, bottom + 2);
                e.gc.drawLine(0, bottom - 6, bounds.width - 2, bottom - 6);
            }
        }
    }

    public class ListElement
    extends Canvas {
        private ITabItem tab;
        private boolean selected;
        private boolean hover;
        private boolean isError;
        private Color imageOnHoverColor;

        public int getElementIndex() {
            return TabbedPropertyList.this.elements.indexOf((Object)this);
        }

        public boolean isError() {
            return this.isError;
        }

        public void setError(boolean isError) {
            this.isError = isError;
        }

        public ListElement(Composite parent, ITabItem tab) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ListElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.this.selected) {
                        int currentIndex = TabbedPropertyList.this.getIndex(ListElement.this);
                        if (((ListElement)ListElement.this).TabbedPropertyList.this.sequentialMode) {
                            if (currentIndex <= ((ListElement)ListElement.this).TabbedPropertyList.this.maxSelectedIndex) {
                                TabbedPropertyList.this.select(currentIndex);
                                ((ListElement)ListElement.this).TabbedPropertyList.this.maxSelectedIndex = Math.max(currentIndex, ((ListElement)ListElement.this).TabbedPropertyList.this.maxSelectedIndex);
                            }
                        } else {
                            TabbedPropertyList.this.select(currentIndex);
                        }
                        Composite tabbedPropertyComposite = ListElement.this.getParent();
                        tabbedPropertyComposite.setFocus();
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.this.hover) {
                        ListElement.this.hover = true;
                        ListElement.this.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.hover = false;
                    ListElement.this.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            if (selected && TabbedPropertyList.this.getIndex(this) > TabbedPropertyList.this.maxSelectedIndex) {
                TabbedPropertyList.this.maxSelectedIndex = this.getElementIndex();
            }
            this.redraw();
        }

        public Color getImageOnHoverColor() {
            return this.imageOnHoverColor;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int customHint = TabbedPropertyList.this.getTabItemHeight();
            hHint = customHint == 0 ? hHint : customHint;
            return super.computeSize(wHint, hHint, true);
        }

        private void paint(PaintEvent e) {
            Rectangle bounds = this.getBounds();
            if (this.selected) {
                e.gc.setBackground(TabbedPropertyList.this.getListBackground());
                e.gc.setForeground(TabbedPropertyList.this.getListBackground());
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height - 1);
            } else if (this.hover && this.tab.isIndented()) {
                e.gc.setBackground(TabbedPropertyList.this.getIndentedHoverBackground());
                e.gc.fillRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            } else if (this.hover) {
                e.gc.setForeground(TabbedPropertyList.this.getHoverGradientStart());
                e.gc.setBackground(TabbedPropertyList.this.getHoverGradientEnd());
                e.gc.fillGradientRectangle(0, 0, bounds.width - 1, bounds.height - 1, true);
            } else if (this.tab.isIndented()) {
                e.gc.setBackground(TabbedPropertyList.this.getIndentedDefaultBackground());
                e.gc.fillRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setForeground(TabbedPropertyList.this.getDefaultGradientStart());
                e.gc.setBackground(TabbedPropertyList.this.getDefaultGradientEnd());
                e.gc.fillGradientRectangle(0, 0, bounds.width - 1, bounds.height - 1, true);
            }
            if (!this.selected) {
                e.gc.setForeground(TabbedPropertyList.this.getWidgetNormalShadow());
            }
            int textIndent = TabbedPropertyList.this.verticalIndent;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.tab.isIndented()) {
                textIndent += TabbedPropertyList.this.verticalIndent;
            }
            if (this.hover) {
                e.gc.setForeground(TabbedPropertyList.this.getHoverWidgetForeground());
            } else if (this.selected) {
                e.gc.setForeground(TabbedPropertyList.this.getSelectedWidgetForeground());
            } else {
                e.gc.setForeground(TabbedPropertyList.this.getWidgetForeground());
            }
            if (this.selected) {
                e.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle, true);
            if (((TabbedPropertyList)this.getParent()).focus && this.selected) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
            if (this.selected) {
                Color color = this.getImageOnHoverColor() != null ? this.getImageOnHoverColor() : TabbedPropertyList.this.getHoverWidgetForeground();
                e.gc.setForeground(color);
                e.gc.setBackground(color);
                e.gc.setLineWidth(3);
                if (TabbedPropertyList.this.isSelectedLineRight()) {
                    e.gc.fillRectangle(bounds.x + bounds.width - 3, 0, 3, bounds.height - 1);
                } else {
                    e.gc.fillRectangle(0, 0, 3, bounds.height - 1);
                }
            }
        }

        public ITabItem getTabItem() {
            return this.tab;
        }

        public String toString() {
            return this.tab.getText();
        }

        public void setImageOnHoverColor(Color imageOnHoverColor) {
            this.imageOnHoverColor = imageOnHoverColor;
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    TopNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.this.isUpScrollRequired()) {
                        --((TopNavigationElement)TopNavigationElement.this).TabbedPropertyList.this.bottomVisibleIndex;
                        if (((TopNavigationElement)TopNavigationElement.this).TabbedPropertyList.this.topVisibleIndex != 0) {
                            --((TopNavigationElement)TopNavigationElement.this).TabbedPropertyList.this.topVisibleIndex;
                        }
                        TabbedPropertyList.this.layoutTabs();
                        ((TopNavigationElement)TopNavigationElement.this).TabbedPropertyList.this.topNavigationElement.redraw();
                        ((TopNavigationElement)TopNavigationElement.this).TabbedPropertyList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.getWidgetBackground());
            e.gc.setForeground(TabbedPropertyList.this.getWidgetForeground());
            Rectangle bounds = this.getBounds();
            if (!TabbedPropertyList.this.elements.isEmpty()) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.getWidgetNormalShadow());
            } else {
                e.gc.setBackground(TabbedPropertyList.this.getListBackground());
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = TabbedPropertyList.this.verticalIndent;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(TabbedPropertyList.this.getWidgetForeground());
                String properties_not_available = "not available";
                e.gc.drawText(properties_not_available, textIndent, textMiddle);
            }
            if (TabbedPropertyList.this.isUpScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.getWidgetDarkShadow());
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
                e.gc.setForeground(TabbedPropertyList.this.getListBackground());
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.setForeground(TabbedPropertyList.this.getWidgetNormalShadow());
                e.gc.drawLine(0, 0, bounds.width - 2, 0);
                e.gc.setForeground(TabbedPropertyList.this.getNavigationElementShadowStroke());
                e.gc.drawLine(0, 1, bounds.width - 2, 1);
                e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
        }
    }
}

