/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.search;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;

public class LimitedLevelPatternFilter
extends PatternFilter {
    private int nodeLevel;
    private int recursionLevel;

    public LimitedLevelPatternFilter(int recursionLevel) {
        this.recursionLevel = recursionLevel;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements, int currentLevel) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            int nextLevel = currentLevel + 1;
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element, nextLevel);
            ++i;
        }
        return elementFound;
    }

    public boolean isElementVisible(Viewer viewer, Object element, int currentLevel) {
        if (currentLevel < this.recursionLevel) {
            return this.isParentMatch(viewer, element, currentLevel) || this.isLeafMatch(viewer, element);
        }
        return false;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        this.nodeLevel = 0;
        return this.isElementVisible(viewer, element, this.nodeLevel);
    }

    protected boolean isParentMatch(Viewer viewer, Object element, int currentLevel) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.computeAnyVisible(viewer, children, currentLevel);
        }
        return false;
    }
}

