/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SharedColors
implements ISharedTextColors {
    private Map<Display, Map<RGB, Color>> fDisplayTable;

    public Color getColor(RGB rgb) {
        Color color;
        Display display;
        Map<RGB, Color> colorTable;
        if (rgb == null) {
            return null;
        }
        if (this.fDisplayTable == null) {
            this.fDisplayTable = new HashMap<Display, Map<RGB, Color>>(2);
        }
        if ((colorTable = this.fDisplayTable.get(display = Display.getCurrent())) == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            display.disposeExec(new Runnable(){

                @Override
                public void run() {
                    SharedColors.this.dispose(display);
                }
            });
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)display, rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (this.fDisplayTable == null) {
            return;
        }
        Iterator<Map<RGB, Color>> iter = this.fDisplayTable.values().iterator();
        while (iter.hasNext()) {
            this.dispose(iter.next());
        }
        this.fDisplayTable = null;
    }

    private void dispose(Display display) {
        if (this.fDisplayTable != null) {
            this.dispose(this.fDisplayTable.remove(display));
        }
    }

    private void dispose(Map<RGB, Color> colorTable) {
        if (colorTable == null) {
            return;
        }
        Iterator<Color> iter = colorTable.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        colorTable.clear();
    }
}

