/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.script;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.mule.tooling.ui.widgets.script.SharedColors;

public class ScriptEditorComposite
extends Composite {
    private static final String CONTENT_ASSIST_ACTION_ID = "content.assist";
    private Map<String, TextViewerAction> actions;
    private ProjectionViewer projectionViewer;
    private SourceViewerConfiguration configuration;
    private IDocumentPartitioner partitioner;

    public ScriptEditorComposite(IDocumentPartitioner partitioner, SourceViewerConfiguration configuration, Composite parent, int style) {
        super(parent, style);
        this.partitioner = partitioner;
        this.configuration = configuration;
        this.actions = new HashMap<String, TextViewerAction>();
        this.setLayout((Layout)new FillLayout());
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        this.setProjectionViewer(this.createProjectionViewer(parent));
        this.getProjectionViewer().configure(this.configuration);
        Document document = new Document();
        this.getPartitioner().connect((IDocument)document);
        this.getProjectionViewer().setDocument((IDocument)document);
        this.createActions();
        this.createContextMenu();
        this.getProjectionViewer().getTextWidget().addKeyListener((org.eclipse.swt.events.KeyListener)new KeyListener());
    }

    protected ProjectionViewer createProjectionViewer(Composite parent) {
        return new ProjectionViewer(parent, (IVerticalRuler)new CompositeRuler(8), (IOverviewRuler)new OverviewRuler((IAnnotationAccess)new DefaultMarkerAnnotationAccess(), 20, (ISharedTextColors)new SharedColors()), true, 0);
    }

    private void createActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 13);
        action.setText("Content Assist Proposals");
        this.registerAction(CONTENT_ASSIST_ACTION_ID, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 1);
        action.setText("&Undo");
        this.registerAction(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 2);
        action.setText("&Redo");
        this.registerAction(ITextEditorActionConstants.REDO, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 4);
        action.setText("&Copy");
        this.registerAction(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 3);
        action.setText("Cu&t");
        this.registerAction(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 5);
        action.setText("&Paste");
        this.registerAction(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.getProjectionViewer(), 7);
        action.setText("Select &All");
        this.registerAction(ITextEditorActionConstants.SELECT_ALL, action);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScriptEditorComposite.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.getProjectionViewer().getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    protected void updateActions() {
        for (IAction iAction : this.actions.values()) {
            if (!(iAction instanceof IUpdate)) continue;
            ((IUpdate)iAction).update();
        }
    }

    private void fillContextMenu(IMenuManager menu) {
        this.updateActions();
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.actions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", (IAction)this.actions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.actions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.actions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.actions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.actions.get(ITextEditorActionConstants.SELECT_ALL));
    }

    public String getText() {
        if (this.getProjectionViewer().getDocument() != null) {
            return this.getProjectionViewer().getDocument().get();
        }
        return "";
    }

    public void setText(String input) {
        this.getProjectionViewer().getDocument().set(input);
    }

    public void registerAction(String contentAssistActionId, TextViewerAction action) {
        this.actions.put(contentAssistActionId, action);
    }

    public ProjectionViewer getProjectionViewer() {
        return this.projectionViewer;
    }

    public void setProjectionViewer(ProjectionViewer projectionViewer) {
        this.projectionViewer = projectionViewer;
    }

    public IDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 32 && (e.stateMask & 0x40000) != 0) {
                this.runAction(ScriptEditorComposite.CONTENT_ASSIST_ACTION_ID);
            }
        }

        private void runAction(String actionID) {
            IAction action = (IAction)ScriptEditorComposite.this.actions.get(actionID);
            if (action.isEnabled()) {
                action.run();
            }
        }
    }
}

