/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.progress.bar;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;

public final class ProgressBarMonitor
extends NullProgressMonitor {
    private long runningTasks = 0L;
    private ProgressBar progressBar;

    public ProgressBarMonitor(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void beginTask(final String name, final int totalWork) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProgressBarMonitor.this.progressBar.isDisposed()) {
                    ProgressBarMonitor.this.progressBar.setVisible(true);
                    if (ProgressBarMonitor.this.runningTasks <= 0L) {
                        ProgressBarMonitor.this.progressBar.setSelection(0);
                        ProgressBarMonitor.this.progressBar.setMaximum(totalWork);
                    } else {
                        ProgressBarMonitor.this.progressBar.setMaximum(ProgressBarMonitor.this.progressBar.getMaximum() + totalWork);
                    }
                    ++ProgressBarMonitor.this.runningTasks;
                    ProgressBarMonitor.this.progressBar.setToolTipText(name);
                }
            }
        });
    }

    public void worked(final int work) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProgressBarMonitor.this.progressBar.isDisposed()) {
                    ProgressBarMonitor.this.progressBar.setSelection(ProgressBarMonitor.this.progressBar.getSelection() + work);
                }
            }
        });
    }

    public IProgressMonitor addJob(Job job) {
        if (job != null) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            --(this).ProgressBarMonitor.this.runningTasks;
                            if ((this).ProgressBarMonitor.this.runningTasks > 0L) {
                                (this).ProgressBarMonitor.this.progressBar.setToolTipText("Currently running: " + (this).ProgressBarMonitor.this.runningTasks);
                            } else if (!(this).ProgressBarMonitor.this.progressBar.isDisposed()) {
                                (this).ProgressBarMonitor.this.progressBar.setSelection((this).ProgressBarMonitor.this.progressBar.getSelection() + ((this).ProgressBarMonitor.this.progressBar.getMaximum() - (this).ProgressBarMonitor.this.progressBar.getSelection()));
                                (this).ProgressBarMonitor.this.progressBar.setToolTipText("No background progress running.");
                                (this).ProgressBarMonitor.this.progressBar.setVisible(false);
                            }
                        }
                    });
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                }
            });
        }
        return this;
    }

    public void done() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProgressBarMonitor.this.progressBar.isDisposed()) {
                    ProgressBarMonitor.this.progressBar.setVisible(false);
                }
            }
        });
    }
}

