/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.p2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.p2.InstallationStatus;
import org.mule.tooling.utils.UtilsPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class InstallerService {
    private final URI uri;
    private final IProvisioningAgent provisioningAgent;
    private Shell parentShell;
    private Map<String, IQueryResult<IInstallableUnit>> cachedResults = new HashMap<String, IQueryResult<IInstallableUnit>>();

    public InstallerService(String url, IProvisioningAgent provisioningAgent) {
        this.provisioningAgent = provisioningAgent;
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI", e);
        }
        this.parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void install(String featureId, String version, IProgressMonitor monitor) {
        try {
            IQueryResult<IInstallableUnit> matches = this.getInstallableUnits(featureId, version, monitor);
            if (!matches.isEmpty()) {
                Iterator it = matches.iterator();
                ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
                while (it.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)it.next();
                    installableUnits.add(iu);
                }
                InstallOperation op = ProvisioningUI.getDefaultUI().getInstallOperation(installableUnits, new URI[]{this.uri});
                IStatus result = op.resolveModal((IProgressMonitor)new NullProgressMonitor());
                if (result.isOK() || result.isMultiStatus()) {
                    ProvisioningUI.getDefaultUI().openInstallWizard(installableUnits, op, null);
                }
            }
        }
        catch (ProvisionException provisionException) {
            MessageDialog.openError((Shell)this.parentShell, (String)"Installation error", (String)("There was a problem loading the update site located at " + String.valueOf(this.uri)));
        }
    }

    public void update(String featureId, String version) {
        try {
            IInstallableUnit myIU;
            UpdateOperation op;
            IStatus result;
            IQueryResult<IInstallableUnit> matches = this.getInstallableUnits(featureId, version, (IProgressMonitor)new NullProgressMonitor());
            if (!matches.isEmpty() && ((result = (op = new UpdateOperation(new ProvisioningSession(this.provisioningAgent), Arrays.asList(myIU = (IInstallableUnit)matches.iterator().next()))).resolveModal((IProgressMonitor)new NullProgressMonitor())).isOK() || result.isMultiStatus())) {
                ProvisioningUI.getDefaultUI().openUpdateWizard(false, op, null);
            }
        }
        catch (ProvisionException provisionException) {
            MessageDialog.openError((Shell)this.parentShell, (String)"Installation error", (String)("There was a problem loading the update site located at " + String.valueOf(this.uri)));
        }
    }

    public InstallationStatus checkInstalled(String featureId, String version) {
        BundleContext bundleContext = UtilsPlugin.getInstance().getBundle().getBundleContext();
        Bundle findBundle = InstallerService.findBundle(bundleContext, featureId);
        if (findBundle == null) {
            return InstallationStatus.NOT_INSTALLED;
        }
        Version bundleVersion = findBundle.getVersion();
        if (bundleVersion.compareTo(Version.parseVersion((String)version)) >= 0) {
            return InstallationStatus.INSTALLED;
        }
        return InstallationStatus.NEEDS_UPDATE;
    }

    private static Bundle findBundle(BundleContext bundleContext, String symbolicName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(symbolicName)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasFeature(String featureId, IProgressMonitor monitor) throws ProvisionException {
        IQueryResult<IInstallableUnit> installableUnits = this.getInstallableUnits(featureId, "0.0.0", monitor);
        return !installableUnits.isEmpty();
    }

    private IQueryResult<IInstallableUnit> getInstallableUnits(String featureId, String version, IProgressMonitor monitor) throws ProvisionException {
        String key = String.valueOf(this.uri) + featureId + version;
        monitor.beginTask("Querying remote repository", 100);
        try {
            if (!this.cachedResults.containsKey(key)) {
                IMetadataRepository metadataManager = ProvisioningUI.getDefaultUI().loadMetadataRepository(this.uri, false, monitor);
                monitor.worked(40);
                IQuery query = featureId != null ? QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)featureId, (VersionRange)this.getVersionRange(version))) : QueryUtil.createIUAnyQuery();
                this.cachedResults.put(key, (IQueryResult<IInstallableUnit>)metadataManager.query(query, (IProgressMonitor)new SubProgressMonitor(monitor, 50)));
                monitor.worked(10);
            } else {
                monitor.worked(100);
            }
        }
        finally {
            monitor.done();
        }
        return this.cachedResults.get(key);
    }

    private VersionRange getVersionRange(String version) {
        org.eclipse.equinox.p2.metadata.Version p2Version;
        VersionRange queryVersionRange = null;
        if (version != null && (p2Version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)version)) != null) {
            org.eclipse.equinox.p2.metadata.Version maxVersion = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)((Integer)p2Version.getSegment(0)), (int)((Integer)p2Version.getSegment(1)), (int)((Integer)p2Version.getSegment(2) + 1));
            queryVersionRange = new VersionRange(p2Version, true, maxVersion, false);
        }
        return queryVersionRange;
    }

    private IMetadataRepositoryManager initializeRepository(IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        metadataManager.addRepository(this.uri);
        metadataManager.loadRepository(this.uri, monitor);
        return metadataManager;
    }

    public void reload(IProgressMonitor monitor) throws ProvisionException {
        this.cachedResults.clear();
        IMetadataRepositoryManager metadataManager = this.initializeRepository(monitor);
        metadataManager.refreshRepository(this.uri, monitor);
    }
}

