/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.notification;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.notification.NotificationPopupColors;
import org.mule.tooling.ui.widgets.notification.SwtUtil;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public abstract class AbstractNotificationPopup
extends Dialog {
    private static final int TITLE_HEIGHT = 30;
    protected int maxWidth = 400;
    protected int minHeight = 80;
    protected static final long DEFAULT_DELAY_CLOSE = 4000L;
    private static final int PADDING_EDGE = 5;
    private long delayClose = 4000L;
    private boolean visible = false;
    private NotificationPopupColors color;
    private final Display display = PlatformUI.getWorkbench().getDisplay();
    private Shell shell;
    private Region lastUsedRegion;
    private Image lastUsedBgImage;
    private Rectangle imageLabelBounds;
    private final Job closeJob = new Job("Closing..."){

        protected IStatus run(IProgressMonitor monitor) {
            if (!AbstractNotificationPopup.this.display.isDisposed()) {
                AbstractNotificationPopup.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = AbstractNotificationPopup.this.getShell();
                        if (shell == null || shell.isDisposed()) {
                            return;
                        }
                        if (AbstractNotificationPopup.this.isMouseOver(shell) || AbstractNotificationPopup.this.isActiveShell(shell)) {
                            AbstractNotificationPopup.this.scheduleAutoClose();
                            return;
                        }
                        AbstractNotificationPopup.this.closeFade();
                    }
                });
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private SwtUtil.FadeJob fadeJob;
    private boolean fadingEnabled;
    protected static final Font BOLD = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    protected static final Image CLOSE_BUTTON_IMAGE_HOVER = WidgetsImages.getImage("/icons/notification/close-hover-16x16.png");

    public AbstractNotificationPopup() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(12);
        this.color = new NotificationPopupColors();
        this.closeJob.setSystem(true);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isFadingEnabled() {
        return this.fadingEnabled;
    }

    public void setFadingEnabled(boolean fadingEnabled) {
        this.fadingEnabled = fadingEnabled;
    }

    protected String getPopupShellTitle() {
        return "Anypoint Studio";
    }

    protected Image getPopupShellImage(int maximumHeight) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0 && (workbenchWindow = windows[0]) != null && !workbenchWindow.getShell().isDisposed()) {
            Image image = this.getShell().getImage();
            int diff = Integer.MAX_VALUE;
            if (image != null && image.getBounds().height <= maximumHeight) {
                diff = maximumHeight - image.getBounds().height;
            } else {
                image = null;
            }
            Image[] images = this.getShell().getImages();
            if (images != null && images.length > 0) {
                Image[] imageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image2 = imageArray[n2];
                    int newDiff = maximumHeight - image2.getBounds().height;
                    if (newDiff >= 0 && newDiff <= diff) {
                        diff = newDiff;
                        image = image2;
                    }
                    ++n2;
                }
            }
            return image;
        }
        return null;
    }

    protected void createContentArea(Composite parent) {
    }

    protected void createTitleBarArea(Composite parent) {
        this.createTitleBarImage(parent);
        this.createTitleBarText(parent);
        this.createTitleBarButtons(parent);
    }

    protected void createTitleBarImage(Composite parent) {
        Label titleImageLabel = new Label(parent, 0);
        titleImageLabel.setImage(this.getPopupShellImage(30));
        this.imageLabelBounds = titleImageLabel.getImage().getBounds();
    }

    protected void createTitleBarText(Composite parent) {
        Label titleTextLabel = new Label(parent, 0);
        titleTextLabel.setText(this.getPopupShellTitle());
        titleTextLabel.setFont(BOLD);
        titleTextLabel.setForeground(this.getTitleForeground());
        titleTextLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    protected void createTitleBarButtons(Composite parent) {
        final Label button = new Label(parent, 0);
        button.setImage(ThemeUtils.getCurrentTheme().getCloseButtonImage());
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                button.setImage(ThemeUtils.getCurrentTheme().getCloseButtonImage());
            }

            public void mouseEnter(MouseEvent e) {
                button.setImage(CLOSE_BUTTON_IMAGE_HOVER);
            }
        });
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AbstractNotificationPopup.this.close();
                AbstractNotificationPopup.this.setReturnCode(1);
            }
        });
    }

    protected Color getTitleForeground() {
        return this.color.getTitleText();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setBackground(this.color.getBorder());
    }

    public void create() {
        super.create();
        this.addRegion(this.shell);
    }

    private void addRegion(Shell shell) {
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        region.subtract(0, s.y, 5, 1);
        region.subtract(0, s.y - 1, 3, 1);
        region.subtract(0, s.y - 2, 2, 1);
        region.subtract(0, s.y - 3, 1, 1);
        region.subtract(0, s.y - 4, 1, 1);
        region.subtract(s.x - 5, s.y - 0, 5, 1);
        region.subtract(s.x - 3, s.y - 1, 3, 1);
        region.subtract(s.x - 2, s.y - 2, 2, 1);
        region.subtract(s.x - 1, s.y - 3, 1, 1);
        region.subtract(s.x - 1, s.y - 4, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.lastUsedRegion = region;
    }

    private boolean isMouseOver(Shell shell) {
        if (this.display.isDisposed()) {
            return false;
        }
        return shell.getBounds().contains(this.display.getCursorLocation());
    }

    private boolean isActiveShell(Shell shell) {
        return shell.equals(this.display.getActiveShell());
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        Shell activeShell = WidgetUtils.getMainWindowShell();
        if (activeShell != null) {
            this.shell.setLocation(activeShell.getSize().x + activeShell.getLocation().x - this.shell.getSize().x - 7, activeShell.getSize().y + activeShell.getLocation().y - this.shell.getSize().y - 25);
        }
        if (this.isFadingEnabled()) {
            this.shell.setAlpha(0);
        }
        this.shell.setVisible(true);
        this.fadeJob = SwtUtil.fadeIn(this.shell, new SwtUtil.IFadeListener(){

            @Override
            public void faded(Shell shell, int alpha) {
                if (shell.isDisposed()) {
                    return;
                }
                if (alpha == 255) {
                    AbstractNotificationPopup.this.scheduleAutoClose();
                }
            }
        });
        this.visible = true;
        return 0;
    }

    protected void scheduleAutoClose() {
        if (this.delayClose > 0L) {
            this.closeJob.schedule(this.delayClose);
        }
    }

    protected Rectangle getImageLabelSize() {
        return this.imageLabelBounds;
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        final Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerCircle.setBackgroundMode(2);
        outerCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = outerCircle.getClientArea();
                AbstractNotificationPopup.this.lastUsedBgImage = new Image((Device)outerCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)AbstractNotificationPopup.this.lastUsedBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                Image oldBGImage = outerCircle.getBackgroundImage();
                outerCircle.setBackgroundImage(AbstractNotificationPopup.this.lastUsedBgImage);
                if (oldBGImage != null) {
                    oldBGImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(AbstractNotificationPopup.this.color.getGradientBegin());
                gc.setBackground(AbstractNotificationPopup.this.color.getGradientEnd());
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(AbstractNotificationPopup.this.color.getBorder());
                gc.drawPoint(2, 0);
                gc.drawPoint(3, 0);
                gc.drawPoint(1, 1);
                gc.drawPoint(0, 2);
                gc.drawPoint(0, 3);
                gc.drawPoint(clArea.width - 4, 0);
                gc.drawPoint(clArea.width - 3, 0);
                gc.drawPoint(clArea.width - 2, 1);
                gc.drawPoint(clArea.width - 1, 2);
                gc.drawPoint(clArea.width - 1, 3);
                gc.drawPoint(2, clArea.height - 0);
                gc.drawPoint(3, clArea.height - 0);
                gc.drawPoint(1, clArea.height - 1);
                gc.drawPoint(0, clArea.height - 2);
                gc.drawPoint(0, clArea.height - 3);
                gc.drawPoint(clArea.width - 4, clArea.height - 0);
                gc.drawPoint(clArea.width - 3, clArea.height - 0);
                gc.drawPoint(clArea.width - 2, clArea.height - 1);
                gc.drawPoint(clArea.width - 1, clArea.height - 2);
                gc.drawPoint(clArea.width - 1, clArea.height - 3);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        outerCircle.setLayout((Layout)layout);
        Composite titleCircle = new Composite(outerCircle, 524288);
        titleCircle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        titleCircle.setBackgroundMode(2);
        layout = new GridLayout(4, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        layout.verticalSpacing = 7;
        layout.horizontalSpacing = 5;
        titleCircle.setLayout((Layout)layout);
        ((GridData)titleCircle.getLayoutData()).heightHint = 30;
        this.createTitleBarArea(titleCircle);
        Composite outerContentCircle = new Composite(outerCircle, 0);
        outerContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerContentCircle.setBackground(outerCircle.getBackground());
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        middleContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.color.getBorder());
        Composite innerContent = new Composite(middleContentCircle, 524288);
        innerContent.setLayoutData((Object)new GridData(4, 4, true, true));
        innerContent.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 7;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        innerContent.setLayout((Layout)layout);
        innerContent.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.createContentArea(innerContent);
        this.setNullBackground(outerCircle);
        return outerCircle;
    }

    private void setNullBackground(Composite outerCircle) {
        Control[] controlArray = outerCircle.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(null);
            if (c instanceof Composite) {
                this.setNullBackground((Composite)c);
            }
            ++n2;
        }
    }

    protected int getMinHeight() {
        return this.minHeight;
    }

    protected int getMaxWidth() {
        return this.maxWidth;
    }

    protected void initializeBounds() {
        Rectangle clArea = this.getPrimaryClientArea();
        Point initialSize = this.shell.computeSize(-1, -1);
        int height = Math.max(initialSize.y, this.getMinHeight());
        int width = Math.min(initialSize.x, this.getMaxWidth());
        Point size = new Point(width, height);
        this.shell.setLocation(clArea.width + clArea.x - size.x - 5, clArea.height + clArea.y - size.y - 5);
        this.shell.setSize(size);
    }

    protected Rectangle getPrimaryClientArea() {
        Monitor primaryMonitor = this.shell.getDisplay().getPrimaryMonitor();
        return primaryMonitor != null ? primaryMonitor.getClientArea() : this.shell.getDisplay().getClientArea();
    }

    public void closeFade() {
        if (this.fadeJob != null) {
            this.fadeJob.cancelAndWait(false);
        }
        if (!this.isActiveShell(this.shell)) {
            this.fadeJob = SwtUtil.fadeOut(this.getShell(), new SwtUtil.IFadeListener(){

                @Override
                public void faded(Shell shell, int alpha) {
                    if (!shell.isDisposed()) {
                        if (alpha == 0) {
                            shell.close();
                        } else if (AbstractNotificationPopup.this.isMouseOver(shell) || AbstractNotificationPopup.this.isActiveShell(shell)) {
                            if (AbstractNotificationPopup.this.fadeJob != null) {
                                AbstractNotificationPopup.this.fadeJob.cancelAndWait(false);
                            }
                            AbstractNotificationPopup.this.fadeJob = SwtUtil.fastFadeIn(shell, new SwtUtil.IFadeListener(){

                                @Override
                                public void faded(Shell shell, int alpha) {
                                    if (shell.isDisposed()) {
                                        return;
                                    }
                                    if (alpha == 255) {
                                        AbstractNotificationPopup.this.scheduleAutoClose();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        } else {
            this.scheduleAutoClose();
        }
    }

    public boolean close() {
        this.visible = false;
        this.color.dispose();
        if (this.lastUsedRegion != null) {
            this.lastUsedRegion.dispose();
        }
        if (this.lastUsedBgImage != null && !this.lastUsedBgImage.isDisposed()) {
            this.lastUsedBgImage.dispose();
        }
        return super.close();
    }

    public long getDelayClose() {
        return this.delayClose;
    }

    public void setDelayClose(long delayClose) {
        this.delayClose = delayClose;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }
}

